/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.parser;

import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.fun.SqlCountAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.util.Litmus;
import org.apache.drill.exec.exception.UnsupportedOperatorCollector;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.sql.parser.DrillCalciteWrapperUtility;
import org.apache.drill.exec.work.foreman.SqlUnsupportedException;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class UnsupportedOperatorsVisitor
extends SqlShuttle {
    private QueryContext context;
    private static List<String> disabledType = Lists.newArrayList();
    private static List<String> disabledOperators = Lists.newArrayList();
    private static List<String> dirExplorers = Lists.newArrayList();
    private UnsupportedOperatorCollector unsupportedOperatorCollector;
    private final SqlNodeCondition RollupCubeGrpSets = new SqlNodeCondition(){

        @Override
        public boolean test(SqlNode sqlNode) {
            SqlOperator operator;
            return sqlNode instanceof SqlCall && ((operator = DrillCalciteWrapperUtility.extractSqlOperatorFromWrapper(((SqlCall)sqlNode).getOperator())) == SqlStdOperatorTable.ROLLUP || operator == SqlStdOperatorTable.CUBE || operator == SqlStdOperatorTable.GROUPING_SETS);
        }
    };
    private final SqlNodeCondition GroupingID = new SqlNodeCondition(){

        @Override
        public boolean test(SqlNode sqlNode) {
            SqlOperator operator;
            return sqlNode instanceof SqlCall && ((operator = DrillCalciteWrapperUtility.extractSqlOperatorFromWrapper(((SqlCall)sqlNode).getOperator())) == SqlStdOperatorTable.GROUPING || operator == SqlStdOperatorTable.GROUPING_ID || operator == SqlStdOperatorTable.GROUP_ID);
        }
    };
    private final SqlNodeCondition DirExplorersCondition = new SqlNodeCondition(){

        @Override
        public boolean test(SqlNode sqlNode) {
            return sqlNode instanceof SqlCall && this.checkOperator((SqlCall)sqlNode, dirExplorers, true);
        }

        private boolean checkOperator(SqlCall sqlCall, List<String> operators, boolean checkOperator) {
            if (checkOperator) {
                return operators.contains(sqlCall.getOperator().getName().toUpperCase()) || this.checkOperator(sqlCall, operators, false);
            }
            for (SqlNode sqlNode : sqlCall.getOperandList()) {
                if (!(sqlNode instanceof SqlCall) || !this.checkOperator((SqlCall)sqlNode, operators, true)) continue;
                return true;
            }
            return false;
        }
    };

    private UnsupportedOperatorsVisitor(QueryContext context) {
        this.context = context;
        this.unsupportedOperatorCollector = new UnsupportedOperatorCollector();
    }

    public static UnsupportedOperatorsVisitor createVisitor(QueryContext context) {
        return new UnsupportedOperatorsVisitor(context);
    }

    public void convertException() throws SqlUnsupportedException {
        this.unsupportedOperatorCollector.convertException();
    }

    public SqlNode visit(SqlDataTypeSpec type) {
        for (String strType : disabledType) {
            if (!type.getTypeName().getSimple().equalsIgnoreCase(strType)) continue;
            this.unsupportedOperatorCollector.setException(SqlUnsupportedException.ExceptionType.DATA_TYPE, type.getTypeName().getSimple() + " is not supported\nSee Apache Drill JIRA: DRILL-1959");
            throw new UnsupportedOperationException();
        }
        return type;
    }

    public SqlNode visit(SqlCall sqlCall) {
        Object join;
        SqlSelect sqlSelect;
        if (sqlCall instanceof SqlSelect) {
            sqlSelect = (SqlSelect)sqlCall;
            this.checkGrouping(sqlSelect);
            this.checkRollupCubeGrpSets(sqlSelect);
            for (SqlNode nodeInSelectList : sqlSelect.getSelectList()) {
                if (nodeInSelectList.getKind() == SqlKind.AS && ((SqlNode)((SqlCall)nodeInSelectList).getOperandList().get(0)).getKind() == SqlKind.OVER) {
                    nodeInSelectList = (SqlNode)((SqlCall)nodeInSelectList).getOperandList().get(0);
                }
                if (nodeInSelectList.getKind() != SqlKind.OVER) continue;
                if (!this.context.getOptions().getOption((String)"window.enable").bool_val.booleanValue()) {
                    this.unsupportedOperatorCollector.setException(SqlUnsupportedException.ExceptionType.FUNCTION, "Window functions are disabled\nSee Apache Drill JIRA: DRILL-2559");
                    throw new UnsupportedOperationException();
                }
                SqlCall over = (SqlCall)nodeInSelectList;
                if (!(over.getOperandList().get(0) instanceof SqlCall)) continue;
                SqlCall function = (SqlCall)over.getOperandList().get(0);
                if (function.getFunctionQuantifier() != null && function.getFunctionQuantifier().getValue() == SqlSelectKeyword.DISTINCT) {
                    this.unsupportedOperatorCollector.setException(SqlUnsupportedException.ExceptionType.FUNCTION, "DISTINCT for window aggregate functions is not currently supported\nSee Apache Drill JIRA: DRILL-3182");
                    throw new UnsupportedOperationException();
                }
                String functionName = function.getOperator().getName().toUpperCase();
                if (!"LEAD".equals(functionName) && !"LAG".equals(functionName)) continue;
                boolean supported = true;
                if (function.operandCount() > 2) {
                    supported = false;
                } else if (function.operandCount() == 2) {
                    SqlNode operand = function.operand(1);
                    if (operand instanceof SqlNumericLiteral) {
                        SqlNumericLiteral offsetLiteral = (SqlNumericLiteral)operand;
                        try {
                            if (offsetLiteral.intValue(true) != 1) {
                                supported = false;
                            }
                        }
                        catch (AssertionError e) {
                            supported = false;
                        }
                    } else {
                        supported = false;
                    }
                }
                if (supported) continue;
                this.unsupportedOperatorCollector.setException(SqlUnsupportedException.ExceptionType.FUNCTION, "Function " + functionName + " only supports (<value expression>) or (<value expression>, 1)\nSee Apache DRILL JIRA: DRILL-3596");
                throw new UnsupportedOperationException();
            }
        }
        if (sqlCall instanceof SqlWindow) {
            boolean isSupported;
            SqlWindow window = (SqlWindow)sqlCall;
            SqlNode sqlNode = window.getLowerBound();
            SqlNode upperBound = window.getUpperBound();
            boolean bl = isSupported = sqlNode == null && upperBound == null;
            if (window.getOrderList().size() != 0 && !window.isRows() && SqlWindow.isUnboundedPreceding((SqlNode)sqlNode) && (upperBound == null || SqlWindow.isCurrentRow((SqlNode)upperBound) || SqlWindow.isUnboundedFollowing((SqlNode)upperBound))) {
                isSupported = true;
            }
            if (window.isRows() && SqlWindow.isUnboundedPreceding((SqlNode)sqlNode) && (upperBound == null || SqlWindow.isCurrentRow((SqlNode)upperBound))) {
                isSupported = true;
            }
            if (!window.isRows() && SqlWindow.isCurrentRow((SqlNode)sqlNode) && SqlWindow.isCurrentRow((SqlNode)upperBound)) {
                isSupported = true;
            }
            if (window.getOrderList().size() == 0 && SqlWindow.isUnboundedPreceding((SqlNode)sqlNode) && SqlWindow.isUnboundedFollowing((SqlNode)upperBound)) {
                isSupported = true;
            }
            if (!isSupported) {
                this.unsupportedOperatorCollector.setException(SqlUnsupportedException.ExceptionType.FUNCTION, "This type of window frame is currently not supported \nSee Apache Drill JIRA: DRILL-3188");
                throw new UnsupportedOperationException();
            }
            if (!window.isAllowPartial()) {
                this.unsupportedOperatorCollector.setException(SqlUnsupportedException.ExceptionType.FUNCTION, "Disallowing partial windows is currently not supported \nSee Apache Drill JIRA: DRILL-3189");
                throw new UnsupportedOperationException();
            }
        }
        if (sqlCall.getKind() == SqlKind.JOIN && (join = (SqlJoin)sqlCall).isNatural()) {
            this.unsupportedOperatorCollector.setException(SqlUnsupportedException.ExceptionType.RELATIONAL, "NATURAL JOIN is not supported\nSee Apache Drill JIRA: DRILL-1986");
            throw new UnsupportedOperationException();
        }
        if (sqlCall.getKind() == SqlKind.UNNEST && !this.context.getPlannerSettings().isUnnestLateralEnabled()) {
            this.unsupportedOperatorCollector.setException(SqlUnsupportedException.ExceptionType.RELATIONAL, "Unnest is not enabled per configuration");
            throw new UnsupportedOperationException();
        }
        for (String string : disabledOperators) {
            if (!sqlCall.getOperator().isName(string, true)) continue;
            this.unsupportedOperatorCollector.setException(SqlUnsupportedException.ExceptionType.FUNCTION, sqlCall.getOperator().getName() + " is not supported\nSee Apache Drill JIRA: DRILL-2115");
            throw new UnsupportedOperationException();
        }
        if (sqlCall instanceof SqlSelect) {
            sqlSelect = (SqlSelect)sqlCall;
            for (SqlNode nodeInSelectList : sqlSelect.getSelectList()) {
                if (!this.checkDirExplorers(nodeInSelectList)) continue;
                this.unsupportedOperatorCollector.setException(SqlUnsupportedException.ExceptionType.FUNCTION, "Directory explorers " + dirExplorers + " functions are not supported in Select List\nSee Apache Drill JIRA: DRILL-3944");
                throw new UnsupportedOperationException();
            }
            if (sqlSelect.hasWhere() && this.checkDirExplorers(sqlSelect.getWhere()) && !this.context.getPlannerSettings().isConstantFoldingEnabled()) {
                this.unsupportedOperatorCollector.setException(SqlUnsupportedException.ExceptionType.FUNCTION, "Directory explorers " + dirExplorers + " functions can not be used when " + PlannerSettings.CONSTANT_FOLDING.getOptionName() + " option is set to false\nSee Apache Drill JIRA: DRILL-3944");
                throw new UnsupportedOperationException();
            }
            if (sqlSelect.hasOrderBy()) {
                for (SqlNode sqlNode : sqlSelect.getOrderList()) {
                    if (this.containsFlatten(sqlNode)) {
                        this.unsupportedOperatorCollector.setException(SqlUnsupportedException.ExceptionType.FUNCTION, "Flatten function is not supported in Order By\nSee Apache Drill JIRA: DRILL-2181");
                        throw new UnsupportedOperationException();
                    }
                    if (!this.checkDirExplorers(sqlNode)) continue;
                    this.unsupportedOperatorCollector.setException(SqlUnsupportedException.ExceptionType.FUNCTION, "Directory explorers " + dirExplorers + " functions are not supported in Order By\nSee Apache Drill JIRA: DRILL-3944");
                    throw new UnsupportedOperationException();
                }
            }
            if (sqlSelect.getGroup() != null) {
                for (SqlNode sqlNode : sqlSelect.getGroup()) {
                    if (this.containsFlatten(sqlNode)) {
                        this.unsupportedOperatorCollector.setException(SqlUnsupportedException.ExceptionType.FUNCTION, "Flatten function is not supported in Group By\nSee Apache Drill JIRA: DRILL-2181");
                        throw new UnsupportedOperationException();
                    }
                    if (!this.checkDirExplorers(sqlNode)) continue;
                    this.unsupportedOperatorCollector.setException(SqlUnsupportedException.ExceptionType.FUNCTION, "Directory explorers " + dirExplorers + " functions are not supported in Group By\nSee Apache Drill JIRA: DRILL-3944");
                    throw new UnsupportedOperationException();
                }
            }
            if (sqlSelect.isDistinct()) {
                for (SqlNode column : sqlSelect.getSelectList()) {
                    if (column.getKind() == SqlKind.AS) {
                        if (!this.containsFlatten((SqlNode)((SqlCall)column).getOperandList().get(0))) continue;
                        this.unsupportedOperatorCollector.setException(SqlUnsupportedException.ExceptionType.FUNCTION, "Flatten function is not supported in Distinct\nSee Apache Drill JIRA: DRILL-2181");
                        throw new UnsupportedOperationException();
                    }
                    if (!this.containsFlatten(column)) continue;
                    this.unsupportedOperatorCollector.setException(SqlUnsupportedException.ExceptionType.FUNCTION, "Flatten function is not supported in Distinct\nSee Apache Drill JIRA: DRILL-2181");
                    throw new UnsupportedOperationException();
                }
            }
        }
        if (DrillCalciteWrapperUtility.extractSqlOperatorFromWrapper(sqlCall.getOperator()) instanceof SqlCountAggFunction) {
            for (SqlNode sqlNode : sqlCall.getOperandList()) {
                if (!this.containsFlatten(sqlNode)) continue;
                this.unsupportedOperatorCollector.setException(SqlUnsupportedException.ExceptionType.FUNCTION, "Flatten function in aggregate functions is not supported\nSee Apache Drill JIRA: DRILL-2181");
                throw new UnsupportedOperationException();
            }
        }
        return (SqlNode)sqlCall.getOperator().acceptCall((SqlVisitor)this, sqlCall);
    }

    private void checkRollupCubeGrpSets(SqlSelect sqlSelect) {
        ExprFinder rollupCubeGrpSetsFinder = new ExprFinder(this.RollupCubeGrpSets);
        sqlSelect.accept((SqlVisitor)rollupCubeGrpSetsFinder);
        if (rollupCubeGrpSetsFinder.find()) {
            this.unsupportedOperatorCollector.setException(SqlUnsupportedException.ExceptionType.FUNCTION, "Rollup, Cube, Grouping Sets are not supported in GROUP BY clause.\nSee Apache Drill JIRA: DRILL-3962");
            throw new UnsupportedOperationException();
        }
    }

    private void checkGrouping(SqlSelect sqlSelect) {
        ExprFinder groupingFinder = new ExprFinder(this.GroupingID);
        sqlSelect.accept((SqlVisitor)groupingFinder);
        if (groupingFinder.find()) {
            this.unsupportedOperatorCollector.setException(SqlUnsupportedException.ExceptionType.FUNCTION, "Grouping, Grouping_ID, Group_ID are not supported.\nSee Apache Drill JIRA: DRILL-3962");
            throw new UnsupportedOperationException();
        }
    }

    private boolean checkDirExplorers(SqlNode sqlNode) {
        ExprFinder dirExplorersFinder = new ExprFinder(this.DirExplorersCondition);
        sqlNode.accept((SqlVisitor)dirExplorersFinder);
        return dirExplorersFinder.find();
    }

    private boolean containsFlatten(SqlNode sqlNode) throws UnsupportedOperationException {
        return sqlNode instanceof SqlCall && ((SqlCall)sqlNode).getOperator().getName().toLowerCase().equals("flatten");
    }

    private void detectMultiplePartitions(SqlSelect sqlSelect) {
        for (SqlNode nodeInSelectList : sqlSelect.getSelectList()) {
            if (nodeInSelectList.getKind() == SqlKind.AS && ((SqlNode)((SqlCall)nodeInSelectList).getOperandList().get(0)).getKind() == SqlKind.OVER) {
                nodeInSelectList = (SqlNode)((SqlCall)nodeInSelectList).getOperandList().get(0);
            }
            if (nodeInSelectList.getKind() != SqlKind.OVER) continue;
            SqlNode definedWindow = null;
            SqlNode window = ((SqlCall)nodeInSelectList).operand(1);
            if (window instanceof SqlIdentifier) {
                for (SqlNode sqlNode : sqlSelect.getWindowList()) {
                    if (!((SqlWindow)sqlNode).getDeclName().equalsDeep(window, Litmus.IGNORE)) continue;
                    window = sqlNode;
                    break;
                }
                assert (!(window instanceof SqlIdentifier)) : "Identifier should have been expanded as a window defined in the window list";
            }
            if (definedWindow == null) {
                definedWindow = window;
                continue;
            }
            if (definedWindow.equalsDeep(window, Litmus.IGNORE)) continue;
            this.unsupportedOperatorCollector.setException(SqlUnsupportedException.ExceptionType.FUNCTION, "Multiple window definitions in a single SELECT list is not currently supported \nSee Apache Drill JIRA: DRILL-3196");
            throw new UnsupportedOperationException();
        }
    }

    static {
        disabledType.add(SqlTypeName.TINYINT.name());
        disabledType.add(SqlTypeName.SMALLINT.name());
        disabledType.add(SqlTypeName.REAL.name());
        disabledOperators.add("CARDINALITY");
        dirExplorers.add("MAXDIR");
        dirExplorers.add("IMAXDIR");
        dirExplorers.add("MINDIR");
        dirExplorers.add("IMINDIR");
    }

    private static interface SqlNodeCondition {
        public boolean test(SqlNode var1);
    }

    private static class ExprFinder
    extends SqlBasicVisitor<Void> {
        private boolean find = false;
        private final SqlNodeCondition condition;

        public ExprFinder(SqlNodeCondition condition) {
            this.condition = condition;
        }

        public boolean find() {
            return this.find;
        }

        public Void visit(SqlCall call) {
            if (this.condition.test((SqlNode)call)) {
                this.find = true;
            }
            return (Void)super.visit(call);
        }
    }
}

