/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.parser.impl;

import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.commons.lang3.StringUtils;
import org.apache.drill.exec.planner.sql.parser.DrillParserUtil;
import org.apache.drill.exec.planner.sql.parser.impl.ParseException;
import org.apache.drill.exec.planner.sql.parser.impl.Token;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;

public class DrillSqlParseException
extends SqlParseException {
    private final String sql;
    private final ParseException parseException;

    public DrillSqlParseException(String sql, SqlParseException sqlParseException) {
        this(sql, sqlParseException.getMessage(), sqlParseException.getPos(), sqlParseException.getExpectedTokenSequences(), sqlParseException.getTokenImages(), sqlParseException.getCause());
    }

    @VisibleForTesting
    public DrillSqlParseException(String sql, SqlParserPos pos) {
        this(sql, null, pos, null, null, null);
    }

    private DrillSqlParseException(String sql, String message, SqlParserPos pos, int[][] expectedTokenSequences, String[] tokenImages, Throwable ex) {
        super(message, pos, expectedTokenSequences, tokenImages, ex);
        this.parseException = ex instanceof ParseException ? (ParseException)ex : null;
        this.sql = sql;
    }

    public String getMessage() {
        if (this.parseException == null || this.parseException.currentToken == null) {
            return super.getMessage();
        }
        int[][] expectedTokenSequences = this.getExpectedTokenSequences();
        String[] tokenImage = this.getTokenImages();
        int maxSize = 0;
        for (int[] expectedTokenSequence : expectedTokenSequences) {
            if (maxSize >= expectedTokenSequence.length) continue;
            maxSize = expectedTokenSequence.length;
        }
        Token tok = this.parseException.currentToken.next;
        StringBuilder sb = new StringBuilder("Encountered \"");
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                sb.append(" ");
            }
            if (tok.kind == 0) {
                sb.append(tokenImage[0]);
                break;
            }
            sb.append(ParseException.add_escapes(tok.image));
            tok = tok.next;
        }
        sb.append("\" at line ").append(this.parseException.currentToken.beginLine).append(", column ").append(this.parseException.currentToken.next.beginColumn).append(".");
        return sb.toString();
    }

    public String getSqlWithErrorPointer() {
        String sqlErrorMessageHeader = "SQL Query: ";
        SqlParserPos pos = this.getPos();
        String formattedSql = this.sql;
        if (pos != null) {
            int issueLineNumber = pos.getLineNum() - 1;
            int issueColumnNumber = pos.getColumnNum() - 1;
            int messageHeaderLength = "SQL Query: ".length();
            int shiftLength = issueLineNumber == 0 ? issueColumnNumber + messageHeaderLength : issueColumnNumber;
            StringBuilder sb = new StringBuilder();
            String[] lines = this.sql.split(DrillParserUtil.EOL);
            for (int i = 0; i < lines.length; ++i) {
                sb.append(lines[i]);
                if (i == issueLineNumber) {
                    sb.append(DrillParserUtil.EOL).append(StringUtils.repeat((char)' ', (int)shiftLength)).append("^");
                }
                if (i >= lines.length - 1) continue;
                sb.append(DrillParserUtil.EOL);
            }
            formattedSql = sb.toString();
        }
        return "SQL Query: " + formattedSql;
    }
}

