/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.types;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.type.DynamicRecordType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypePrecedenceList;
import org.apache.calcite.sql.type.SqlTypeExplicitPrecedenceList;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.exec.planner.types.AbstractRelDataTypeHolder;

public class RelDataTypeDrillImpl
extends DynamicRecordType {
    private final RelDataTypeFactory typeFactory;
    private final AbstractRelDataTypeHolder holder;

    public RelDataTypeDrillImpl(AbstractRelDataTypeHolder holder, RelDataTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
        this.holder = holder;
        this.holder.setRelDataTypeFactory(typeFactory);
        this.computeDigest();
    }

    public List<RelDataTypeField> getFieldList() {
        return this.holder.getFieldList(this.typeFactory);
    }

    public int getFieldCount() {
        return this.holder.getFieldCount();
    }

    public RelDataTypeField getField(String fieldName, boolean caseSensitive, boolean elideRecord) {
        return this.holder.getField(this.typeFactory, fieldName);
    }

    public List<String> getFieldNames() {
        return this.holder.getFieldNames();
    }

    public SqlTypeName getSqlTypeName() {
        return SqlTypeName.ANY;
    }

    public RelDataTypePrecedenceList getPrecedenceList() {
        return new SqlTypeExplicitPrecedenceList(Collections.emptyList());
    }

    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        sb.append("(DrillRecordRow" + this.getFieldNames() + ")");
    }

    public boolean isStruct() {
        return true;
    }

    public int hashCode() {
        return this.holder == null ? 0 : this.holder.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RelDataTypeDrillImpl other = (RelDataTypeDrillImpl)((Object)obj);
        return !(this.holder == null ? other.holder != null : !this.holder.equals(other.holder));
    }

    public RelDataTypeFamily getFamily() {
        return this.getSqlTypeName().getFamily();
    }
}

