/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.types;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.DynamicRecordType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.exec.planner.types.AbstractRelDataTypeHolder;

public class RelDataTypeHolder
extends AbstractRelDataTypeHolder {
    public RelDataTypeHolder() {
        super(new ArrayList<RelDataTypeField>());
    }

    @Override
    public List<RelDataTypeField> getFieldList(RelDataTypeFactory typeFactory) {
        this.addStarIfEmpty(typeFactory);
        return this.fields;
    }

    @Override
    public int getFieldCount() {
        this.addStarIfEmpty(this.typeFactory);
        return this.fields.size();
    }

    private void addStarIfEmpty(RelDataTypeFactory typeFactory) {
        if (this.fields.isEmpty()) {
            this.getField(typeFactory, "**");
        }
    }

    @Override
    public RelDataTypeField getField(RelDataTypeFactory typeFactory, String fieldName) {
        for (RelDataTypeField f : this.fields) {
            if (!fieldName.equalsIgnoreCase(f.getName())) continue;
            return f;
        }
        SqlTypeName typeName = DynamicRecordType.isDynamicStarColName((String)fieldName) ? SqlTypeName.DYNAMIC_STAR : SqlTypeName.ANY;
        RelDataTypeFieldImpl newField = new RelDataTypeFieldImpl(fieldName, this.fields.size(), typeFactory.createTypeWithNullability(typeFactory.createSqlType(typeName), true));
        this.fields.add(newField);
        return newField;
    }
}

