/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.types.decimal;

import org.apache.drill.exec.planner.types.DrillRelDataTypeSystem;
import org.apache.drill.exec.planner.types.decimal.DrillBaseComputeScalePrecision;

public class DecimalScalePrecisionDivideFunction
extends DrillBaseComputeScalePrecision {
    public DecimalScalePrecisionDivideFunction(int leftPrecision, int leftScale, int rightPrecision, int rightScale) {
        super(leftPrecision, leftScale, rightPrecision, rightScale);
    }

    @Override
    public void computeScalePrecision(int leftPrecision, int leftScale, int rightPrecision, int rightScale) {
        int maxResultIntegerDigits = Math.min(leftPrecision - leftScale + rightScale, MAX_NUMERIC_PRECISION);
        this.outputScale = Math.max(6, leftScale + rightPrecision + 1);
        this.outputScale = Math.min(this.outputScale, MAX_NUMERIC_PRECISION - maxResultIntegerDigits);
        this.outputScale = Math.min(this.outputScale, DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericScale());
        this.outputPrecision = maxResultIntegerDigits + this.outputScale;
        this.adjustScaleAndPrecision();
    }
}

