/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.types.decimal;

import org.apache.drill.exec.planner.types.DrillRelDataTypeSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DrillBaseComputeScalePrecision {
    private static final Logger logger = LoggerFactory.getLogger(DrillBaseComputeScalePrecision.class);
    protected static final int MAX_NUMERIC_PRECISION = DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision();
    protected int outputScale = 0;
    protected int outputPrecision = 0;

    public DrillBaseComputeScalePrecision(int leftPrecision, int leftScale, int rightPrecision, int rightScale) {
        this.computeScalePrecision(leftPrecision, leftScale, rightPrecision, rightScale);
    }

    public abstract void computeScalePrecision(int var1, int var2, int var3, int var4);

    public int getOutputScale() {
        return this.outputScale;
    }

    public int getOutputPrecision() {
        return this.outputPrecision;
    }

    protected void adjustScaleAndPrecision() {
        if (this.outputPrecision > MAX_NUMERIC_PRECISION) {
            this.outputScale -= this.outputPrecision - MAX_NUMERIC_PRECISION;
            this.outputPrecision = MAX_NUMERIC_PRECISION;
        }
        if (this.outputScale < 0) {
            logger.warn("Resulting precision: {} may overflow max allowed precision: {}.\nForced setting max allowed precision and 0 scale.", (Object)(MAX_NUMERIC_PRECISION - this.outputScale), (Object)MAX_NUMERIC_PRECISION);
            this.outputScale = 0;
        }
    }
}

