/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record;

import io.netty.buffer.ByteBuf;
import org.apache.drill.exec.proto.BitData;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.WritableBatch;

public class FragmentWritableBatch {
    private static UserBitShared.RecordBatchDef EMPTY_DEF = UserBitShared.RecordBatchDef.newBuilder().setRecordCount(0).build();
    private final ByteBuf[] buffers;
    private final BitData.FragmentRecordBatch header;

    public FragmentWritableBatch(boolean isLast, UserBitShared.QueryId queryId, int sendMajorFragmentId, int sendMinorFragmentId, int receiveMajorFragmentId, int receiveMinorFragmentId, WritableBatch batch) {
        this(isLast, queryId, sendMajorFragmentId, sendMinorFragmentId, receiveMajorFragmentId, new int[]{receiveMinorFragmentId}, batch.getDef(), batch.getBuffers());
    }

    public FragmentWritableBatch(boolean isLast, UserBitShared.QueryId queryId, int sendMajorFragmentId, int sendMinorFragmentId, int receiveMajorFragmentId, int[] receiveMinorFragmentIds, WritableBatch batch) {
        this(isLast, queryId, sendMajorFragmentId, sendMinorFragmentId, receiveMajorFragmentId, receiveMinorFragmentIds, batch.getDef(), batch.getBuffers());
    }

    private FragmentWritableBatch(boolean isLast, UserBitShared.QueryId queryId, int sendMajorFragmentId, int sendMinorFragmentId, int receiveMajorFragmentId, int[] receiveMinorFragmentId, UserBitShared.RecordBatchDef def, ByteBuf ... buffers) {
        this.buffers = buffers;
        BitData.FragmentRecordBatch.Builder builder = BitData.FragmentRecordBatch.newBuilder().setIsLastBatch(isLast).setDef(def).setQueryId(queryId).setReceivingMajorFragmentId(receiveMajorFragmentId).setSendingMajorFragmentId(sendMajorFragmentId).setSendingMinorFragmentId(sendMinorFragmentId);
        for (int fragmentId : receiveMinorFragmentId) {
            builder.addReceivingMinorFragmentId(fragmentId);
        }
        this.header = builder.build();
    }

    public static FragmentWritableBatch getEmptyLast(UserBitShared.QueryId queryId, int sendMajorFragmentId, int sendMinorFragmentId, int receiveMajorFragmentId, int receiveMinorFragmentId) {
        return FragmentWritableBatch.getEmptyLast(queryId, sendMajorFragmentId, sendMinorFragmentId, receiveMajorFragmentId, new int[]{receiveMinorFragmentId});
    }

    public static FragmentWritableBatch getEmptyLast(UserBitShared.QueryId queryId, int sendMajorFragmentId, int sendMinorFragmentId, int receiveMajorFragmentId, int[] receiveMinorFragmentIds) {
        return new FragmentWritableBatch(true, queryId, sendMajorFragmentId, sendMinorFragmentId, receiveMajorFragmentId, receiveMinorFragmentIds, EMPTY_DEF, new ByteBuf[0]);
    }

    public static FragmentWritableBatch getEmptyLastWithSchema(UserBitShared.QueryId queryId, int sendMajorFragmentId, int sendMinorFragmentId, int receiveMajorFragmentId, int receiveMinorFragmentId, BatchSchema schema) {
        return FragmentWritableBatch.getEmptyBatchWithSchema(true, queryId, sendMajorFragmentId, sendMinorFragmentId, receiveMajorFragmentId, receiveMinorFragmentId, schema);
    }

    public static FragmentWritableBatch getEmptyBatchWithSchema(boolean isLast, UserBitShared.QueryId queryId, int sendMajorFragmentId, int sendMinorFragmentId, int receiveMajorFragmentId, int receiveMinorFragmentId, BatchSchema schema) {
        UserBitShared.RecordBatchDef.Builder def = UserBitShared.RecordBatchDef.newBuilder();
        if (schema != null) {
            for (MaterializedField field : schema) {
                def.addField(field.getSerializedField());
            }
        }
        return new FragmentWritableBatch(isLast, queryId, sendMajorFragmentId, sendMinorFragmentId, receiveMajorFragmentId, new int[]{receiveMinorFragmentId}, def.build(), new ByteBuf[0]);
    }

    public ByteBuf[] getBuffers() {
        return this.buffers;
    }

    public long getByteCount() {
        long n = 0L;
        for (ByteBuf buf : this.buffers) {
            n += (long)buf.readableBytes();
        }
        return n;
    }

    public BitData.FragmentRecordBatch getHeader() {
        return this.header;
    }
}

