/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record;

import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.vector.AllocationHelper;
import org.apache.drill.exec.vector.ValueVector;

public class VectorAccessibleUtilities {
    private VectorAccessibleUtilities() {
    }

    public static void clear(VectorAccessible va) {
        for (VectorWrapper w : va) {
            w.clear();
        }
    }

    public static void clear(Iterable<ValueVector> iter) {
        for (ValueVector v : iter) {
            v.clear();
        }
    }

    public static void setValueCount(VectorAccessible va, int count) {
        for (VectorWrapper w : va) {
            w.getValueVector().getMutator().setValueCount(count);
        }
    }

    public static void allocateVectors(VectorAccessible va, int targetRecordCount) {
        for (VectorWrapper w : va) {
            AllocationHelper.allocateNew(w.getValueVector(), targetRecordCount);
        }
    }
}

