/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record.metadata;

import java.util.stream.Collectors;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.metadata.AbstractMapColumnMetadata;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleSchema;

public class DictColumnMetadata
extends AbstractMapColumnMetadata {
    public DictColumnMetadata(MaterializedField schema) {
        this(schema, null);
    }

    public DictColumnMetadata(String name, TypeProtos.DataMode mode) {
        this(name, mode, null);
    }

    public DictColumnMetadata(DictColumnMetadata from) {
        super(from);
    }

    DictColumnMetadata(MaterializedField schema, TupleSchema tupleSchema) {
        super(schema, tupleSchema);
    }

    DictColumnMetadata(String name, TypeProtos.DataMode mode, TupleSchema tupleSchema) {
        super(name, TypeProtos.MinorType.DICT, mode, tupleSchema);
    }

    public ColumnMetadata keyColumnMetadata() {
        return this.schema.metadata("key");
    }

    public ColumnMetadata valueColumnMetadata() {
        return this.schema.metadata("value");
    }

    @Override
    public ColumnMetadata copy() {
        return new DictColumnMetadata(this);
    }

    @Override
    public ColumnMetadata cloneEmpty() {
        DictColumnMetadata colMeta = new DictColumnMetadata(this.name, this.mode, new TupleSchema());
        colMeta.setProperties(this.properties());
        return colMeta;
    }

    @Override
    public boolean isDict() {
        return true;
    }

    @Override
    protected String internalTypeString() {
        StringBuilder builder = new StringBuilder().append("MAP<");
        ColumnMetadata key = this.keyColumnMetadata();
        ColumnMetadata value = this.valueColumnMetadata();
        if (key == null || value == null) {
            builder.append(this.tupleSchema().toMetadataList().stream().map(ColumnMetadata::columnString).collect(Collectors.joining(", ")));
        } else {
            builder.append(key.typeString()).append(", ").append(value.typeString());
            if (TypeProtos.DataMode.REQUIRED == value.mode()) {
                builder.append(" NOT NULL");
            }
        }
        builder.append(">");
        return builder.toString();
    }

    @Override
    public ColumnMetadata.StructureType structureType() {
        return ColumnMetadata.StructureType.DICT;
    }
}

