/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record.metadata;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.metadata.AbstractColumnMetadata;
import org.apache.drill.exec.record.metadata.ColumnMetadata;

public class DynamicColumn
extends AbstractColumnMetadata {
    public static final String WILDCARD = "**";
    public static final DynamicColumn WILDCARD_COLUMN = new DynamicColumn("**");

    public DynamicColumn(String name) {
        super(name, TypeProtos.MinorType.LATE, TypeProtos.DataMode.REQUIRED);
    }

    @Override
    public ColumnMetadata.StructureType structureType() {
        return ColumnMetadata.StructureType.DYNAMIC;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public MaterializedField schema() {
        return MaterializedField.create(this.name, this.majorType());
    }

    @Override
    public MaterializedField emptySchema() {
        return this.schema();
    }

    @Override
    public ColumnMetadata cloneEmpty() {
        return this.copy();
    }

    @Override
    public ColumnMetadata copy() {
        return new DynamicColumn(this.name);
    }

    @Override
    public boolean isEquivalent(ColumnMetadata o) {
        if (o == this) {
            return true;
        }
        DynamicColumn other = (DynamicColumn)o;
        return this.name.equalsIgnoreCase(other.name);
    }

    @Override
    public String columnString() {
        return "`" + this.escapeSpecialSymbols(this.name()) + "`" + " " + this.typeString();
    }

    @Override
    public String typeString() {
        return "DYNAMIC";
    }
}

