/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record.metadata;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.apache.drill.common.types.BooleanType;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.BasicTypeHelper;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.metadata.AbstractColumnMetadata;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.Propertied;
import org.apache.drill.exec.record.metadata.PropertyAccessor;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimitiveColumnMetadata
extends AbstractColumnMetadata {
    private static final Logger logger = LoggerFactory.getLogger(PrimitiveColumnMetadata.class);
    private boolean forUnknownSchema;

    public PrimitiveColumnMetadata(MaterializedField schema) {
        super(schema);
    }

    public PrimitiveColumnMetadata(String name, TypeProtos.MajorType type) {
        super(name, type);
    }

    public PrimitiveColumnMetadata(String name, TypeProtos.MinorType type, TypeProtos.DataMode mode) {
        super(name, type, mode);
    }

    public PrimitiveColumnMetadata(String name, TypeProtos.MinorType type, TypeProtos.DataMode mode, boolean forUnknownSchema) {
        this(name, type, mode);
        this.forUnknownSchema = forUnknownSchema;
    }

    private int estimateWidth(TypeProtos.MajorType majorType) {
        if (this.type() == TypeProtos.MinorType.NULL || this.type() == TypeProtos.MinorType.LATE) {
            return 0;
        }
        if (this.isVariableWidth()) {
            int precision = majorType.getPrecision();
            if (precision > 0) {
                return precision;
            }
            return BasicTypeHelper.getSize(majorType) - 4;
        }
        return BasicTypeHelper.getSize(majorType);
    }

    public PrimitiveColumnMetadata(PrimitiveColumnMetadata from) {
        super(from);
    }

    @Override
    public ColumnMetadata copy() {
        return new PrimitiveColumnMetadata(this);
    }

    @Override
    public ColumnMetadata.StructureType structureType() {
        return ColumnMetadata.StructureType.PRIMITIVE;
    }

    @Override
    public int expectedWidth() {
        int width = PropertyAccessor.getInt(this, "drill.width");
        if (width == 0) {
            width = this.estimateWidth(this.majorType());
        }
        return width;
    }

    @Override
    public int precision() {
        return this.precision;
    }

    @Override
    public int scale() {
        return this.scale;
    }

    @Override
    public void setExpectedWidth(int width) {
        if (this.isVariableWidth()) {
            PropertyAccessor.set((Propertied)this, "drill.width", Math.max(1, width));
        }
    }

    @Override
    public DateTimeFormatter dateTimeFormatter() {
        String formatValue = this.format();
        try {
            switch (this.type) {
                case TIME: {
                    return formatValue == null ? DateTimeFormatter.ISO_LOCAL_TIME : DateTimeFormatter.ofPattern(formatValue);
                }
                case DATE: {
                    formatValue = this.format();
                    return formatValue == null ? DateTimeFormatter.ISO_LOCAL_DATE : DateTimeFormatter.ofPattern(formatValue);
                }
                case TIMESTAMP: {
                    formatValue = this.format();
                    return formatValue == null ? DateTimeFormatter.ISO_LOCAL_DATE_TIME : DateTimeFormatter.ofPattern(formatValue);
                }
            }
            throw new IllegalArgumentException("Column is not a date/time type: " + this.type.toString());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("The format \"%s\" is not valid for type %s", formatValue, this.type), e);
        }
    }

    @Override
    public ColumnMetadata cloneEmpty() {
        return new PrimitiveColumnMetadata(this);
    }

    public ColumnMetadata mergeWith(MaterializedField field) {
        PrimitiveColumnMetadata merged = new PrimitiveColumnMetadata(field);
        merged.setExpectedWidth(Math.max(this.expectedWidth(), field.getPrecision()));
        merged.setProperties(this.properties());
        return merged;
    }

    @Override
    public TypeProtos.MajorType majorType() {
        TypeProtos.MajorType.Builder builder = TypeProtos.MajorType.newBuilder().setMinorType(this.type).setMode(this.mode);
        if (this.precision >= 0) {
            builder.setPrecision(this.precision);
        }
        if (this.scale >= 0) {
            builder.setScale(this.scale);
        }
        return builder.build();
    }

    @Override
    public MaterializedField schema() {
        return MaterializedField.create(this.name, this.majorType());
    }

    @Override
    public MaterializedField emptySchema() {
        return this.schema();
    }

    @Override
    public String typeString() {
        StringBuilder builder = new StringBuilder();
        if (this.isArray()) {
            builder.append("ARRAY<");
        }
        switch (this.type) {
            case VARDECIMAL: {
                builder.append("DECIMAL");
                break;
            }
            case FLOAT4: {
                builder.append("FLOAT");
                break;
            }
            case FLOAT8: {
                builder.append("DOUBLE");
                break;
            }
            case BIT: {
                builder.append("BOOLEAN");
                break;
            }
            case INTERVALYEAR: {
                builder.append("INTERVAL YEAR");
                break;
            }
            case INTERVALDAY: {
                builder.append("INTERVAL DAY");
                break;
            }
            default: {
                builder.append(this.type.name());
            }
        }
        if (this.precision() >= 0) {
            builder.append("(").append(this.precision());
            if (this.scale() >= 0) {
                builder.append(", ").append(this.scale());
            }
            builder.append(")");
        }
        if (this.isArray()) {
            builder.append(">");
        }
        return builder.toString();
    }

    @Override
    public Object valueFromString(String value) {
        if (value == null) {
            return null;
        }
        try {
            switch (this.type) {
                case INT: {
                    return Integer.parseInt(value);
                }
                case BIGINT: {
                    return Long.parseLong(value);
                }
                case FLOAT4: {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case FLOAT8: {
                    return Double.parseDouble(value);
                }
                case VARDECIMAL: {
                    return new BigDecimal(value);
                }
                case BIT: {
                    return BooleanType.fromString(value);
                }
                case VARCHAR: 
                case VARBINARY: {
                    return value;
                }
                case TIME: {
                    return LocalTime.parse(value, this.dateTimeFormatter());
                }
                case DATE: {
                    return LocalDate.parse(value, this.dateTimeFormatter());
                }
                case TIMESTAMP: {
                    return LocalDateTime.parse(value, this.dateTimeFormatter()).toInstant(ZoneOffset.UTC);
                }
                case INTERVALYEAR: 
                case INTERVALDAY: 
                case INTERVAL: {
                    return Period.parse((String)value);
                }
            }
            throw new IllegalArgumentException("Unsupported conversion: " + this.type.toString());
        }
        catch (IllegalArgumentException e) {
            logger.warn("Error while parsing type {} default value {}", new Object[]{this.type, value, e});
            throw new IllegalArgumentException(String.format("The string \"%s\" is not valid for type %s", value, this.type), e);
        }
    }

    @Override
    public String valueToString(Object value) {
        if (value == null) {
            return null;
        }
        switch (this.type) {
            case TIME: {
                return this.dateTimeFormatter().format((LocalTime)value);
            }
            case DATE: {
                return this.dateTimeFormatter().format((LocalDate)value);
            }
            case TIMESTAMP: {
                return this.dateTimeFormatter().format((Instant)value);
            }
        }
        return value.toString();
    }

    @Override
    public boolean isEquivalent(ColumnMetadata o) {
        if (!super.isEquivalent(o)) {
            return false;
        }
        PrimitiveColumnMetadata other = (PrimitiveColumnMetadata)o;
        switch (this.type) {
            case DECIMAL18: 
            case DECIMAL28DENSE: 
            case DECIMAL28SPARSE: 
            case DECIMAL38DENSE: 
            case DECIMAL38SPARSE: 
            case DECIMAL9: {
                return Objects.equals(this.precision, other.precision) && Objects.equals(this.scale, other.scale);
            }
            case VARDECIMAL: 
            case VARCHAR: 
            case VARBINARY: 
            case VAR16CHAR: {
                return this.precision <= 0 && other.precision <= 0 || Objects.equals(this.precision, other.precision);
            }
        }
        return true;
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    public boolean isSchemaForUnknown() {
        return this.forUnknownSchema;
    }
}

