/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record.metadata;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.DictBuilder;
import org.apache.drill.exec.record.metadata.MapBuilder;
import org.apache.drill.exec.record.metadata.RepeatedListBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.SchemaContainer;
import org.apache.drill.exec.record.metadata.VariantColumnMetadata;
import org.apache.drill.exec.record.metadata.VariantSchema;

public class UnionBuilder
implements SchemaContainer {
    private final SchemaContainer parent;
    private final String name;
    private final TypeProtos.MinorType type;
    private final VariantSchema union;

    public UnionBuilder(String name, TypeProtos.MinorType type) {
        this(null, name, type);
    }

    public UnionBuilder(SchemaContainer parent, String name, TypeProtos.MinorType type) {
        this.parent = parent;
        this.name = name;
        this.type = type;
        this.union = new VariantSchema();
    }

    private void checkType(TypeProtos.MinorType type) {
        if (this.union.hasType(type)) {
            throw new IllegalArgumentException("Duplicate type: " + type);
        }
    }

    @Override
    public void addColumn(ColumnMetadata column) {
        assert (column.name().equals(Types.typeKey(column.type())));
        this.union.addType(column);
    }

    public UnionBuilder addType(TypeProtos.MinorType type) {
        this.checkType(type);
        this.union.addType(type);
        return this;
    }

    public MapBuilder addMap() {
        this.checkType(TypeProtos.MinorType.MAP);
        return new MapBuilder(this, Types.typeKey(TypeProtos.MinorType.MAP), TypeProtos.DataMode.OPTIONAL);
    }

    public UnionBuilder addList() {
        this.checkType(TypeProtos.MinorType.LIST);
        return new UnionBuilder(this, Types.typeKey(TypeProtos.MinorType.LIST), TypeProtos.MinorType.LIST);
    }

    public RepeatedListBuilder addRepeatedList() {
        this.checkType(TypeProtos.MinorType.LIST);
        return new RepeatedListBuilder(this, Types.typeKey(TypeProtos.MinorType.LIST));
    }

    public DictBuilder addDict() {
        this.checkType(TypeProtos.MinorType.DICT);
        return new DictBuilder(this, Types.typeKey(TypeProtos.MinorType.DICT), TypeProtos.DataMode.OPTIONAL);
    }

    public VariantColumnMetadata buildColumn() {
        return VariantColumnMetadata.variantOf(this.name, this.type, this.union);
    }

    public void build() {
        if (this.parent != null) {
            this.parent.addColumn(this.buildColumn());
        }
    }

    public SchemaBuilder resumeSchema() {
        this.build();
        return (SchemaBuilder)this.parent;
    }

    public MapBuilder resumeMap() {
        this.build();
        return (MapBuilder)this.parent;
    }

    public UnionBuilder resumeUnion() {
        this.build();
        return (UnionBuilder)this.parent;
    }

    public RepeatedListBuilder resumeList() {
        this.build();
        return (RepeatedListBuilder)this.parent;
    }

    public DictBuilder resumeDict() {
        this.build();
        return (DictBuilder)this.parent;
    }

    public RepeatedListBuilder resumeRepeatedList() {
        this.build();
        return (RepeatedListBuilder)this.parent;
    }
}

