/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record.metadata.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.drill.exec.record.metadata.schema.PathSchemaProvider;
import org.apache.drill.exec.record.metadata.schema.SchemaContainer;
import org.apache.drill.exec.store.dfs.WorkspaceSchemaFactory;
import org.apache.hadoop.fs.Path;

public class FsMetastoreSchemaProvider
extends PathSchemaProvider {
    private final String tableName;

    public FsMetastoreSchemaProvider(WorkspaceSchemaFactory.WorkspaceSchema wsSchema, String tableName) throws IOException {
        super(wsSchema.getFS(), FsMetastoreSchemaProvider.generatePath(wsSchema, tableName));
        this.tableName = String.format("%s.`%s`", wsSchema.getFullSchemaName(), tableName);
    }

    private static Path generatePath(WorkspaceSchemaFactory.WorkspaceSchema wsSchema, String tableName) throws IOException {
        Path tablePath = new Path(wsSchema.getDefaultLocation(), tableName);
        if (wsSchema.getFS().isFile(tablePath)) {
            throw new IOException(String.format("Indicated table [%s.%s] must be a directory", wsSchema.getFullSchemaName(), tableName));
        }
        return new Path(tablePath, ".drill.schema");
    }

    @Override
    protected SchemaContainer createTableSchema(String schema, Map<String, String> properties) throws IOException {
        return new SchemaContainer(this.tableName, schema, properties);
    }
}

