/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record.metadata.schema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.Map;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.schema.parser.SchemaExprParser;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class SchemaContainer {
    private final String table;
    private final TupleMetadata schema;
    private final Version version;

    @JsonCreator
    public SchemaContainer(@JsonProperty(value="table") String table, @JsonProperty(value="schema") TupleMetadata schema, @JsonProperty(value="version") Integer version) {
        this.table = table;
        this.schema = schema;
        this.version = new Version(version);
    }

    public SchemaContainer(String table, String schema, Map<String, String> properties) throws IOException {
        this(table, schema, properties, 1);
    }

    public SchemaContainer(String table, String schema, Map<String, String> properties, Integer version) throws IOException {
        this.table = table;
        this.schema = schema == null ? null : this.convert(schema, properties);
        this.version = new Version(version);
    }

    @JsonProperty(value="table")
    public String getTable() {
        return this.table;
    }

    @JsonProperty(value="schema")
    public TupleMetadata getSchema() {
        return this.schema;
    }

    @JsonProperty(value="version")
    public Integer getVersionValue() {
        return this.version.getValue();
    }

    @JsonIgnore
    public Version getVersion() {
        return this.version;
    }

    private TupleMetadata convert(String schemaString, Map<String, String> properties) throws IOException {
        TupleMetadata schema = SchemaExprParser.parseSchema(schemaString);
        if (properties != null) {
            schema.setProperties(properties);
        }
        return schema;
    }

    public String toString() {
        return "SchemaContainer{table='" + this.table + '\'' + ", schema=" + this.schema + ", version=" + this.version + '}';
    }

    public static class Version {
        public static final int UNDEFINED_VERSION = -1;
        public static final int VERSION_1 = 1;
        public static final int CURRENT_DEFAULT_VERSION = 1;
        private final int value;

        public Version(Integer value) {
            this.value = value == null || value < 1 ? -1 : value;
        }

        public int getValue() {
            return this.value;
        }

        public boolean isUndefined() {
            return -1 == this.value;
        }

        public int compare(Version versionToCompare) {
            return Integer.compare(this.value, versionToCompare.value);
        }

        public String toString() {
            return "Version{value=" + this.value + '}';
        }
    }
}

