/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.resolver;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.resolver.FunctionResolver;
import org.apache.drill.exec.resolver.TypeCastRules;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class ExactFunctionResolver
implements FunctionResolver {
    @Override
    public DrillFuncHolder getBestMatch(List<DrillFuncHolder> methods, FunctionCall call) {
        ArrayList<TypeProtos.MajorType> argumentTypes = Lists.newArrayList();
        for (LogicalExpression expression : call.args()) {
            argumentTypes.add(expression.getMajorType());
        }
        for (DrillFuncHolder h : methods) {
            float currCost = TypeCastRules.getCost(argumentTypes, h);
            if (currCost != 0.0f) continue;
            return h;
        }
        return null;
    }
}

