/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.resourcemgr.config;

import com.typesafe.config.Config;
import java.util.UUID;
import org.apache.drill.exec.resourcemgr.NodeResources;
import org.apache.drill.exec.resourcemgr.config.QueryQueueConfig;
import org.apache.drill.exec.resourcemgr.config.exception.RMConfigException;
import org.apache.drill.exec.resourcemgr.util.MemoryConfigParser;

public class QueryQueueConfigImpl
implements QueryQueueConfig {
    private static final String MAX_ADMISSIBLE_KEY = "max_admissible";
    private static final String MAX_WAITING_KEY = "max_waiting";
    private static final String MAX_WAIT_TIMEOUT_KEY = "max_wait_timeout";
    private static final String WAIT_FOR_PREFERRED_NODES_KEY = "wait_for_preferred_nodes";
    private static final String MAX_QUERY_MEMORY_PER_NODE_FORMAT = "([0-9]+)\\s*([kKmMgG]?)\\s*$";
    private static final String MAX_QUERY_MEMORY_PER_NODE_KEY = "max_query_memory_per_node";
    private final String queueUUID = UUID.randomUUID().toString();
    private final String queueName;
    private int maxAdmissibleQuery;
    private int maxWaitingQuery;
    private int maxWaitingTimeout;
    private boolean waitForPreferredNodes;
    private final NodeResources queueResourceShare;
    private NodeResources queryPerNodeResourceShare;

    public QueryQueueConfigImpl(Config queueConfig, String poolName, NodeResources queueNodeResource) throws RMConfigException {
        this.queueName = poolName;
        this.queueResourceShare = queueNodeResource;
        this.parseQueueConfig(queueConfig);
    }

    private void parseQueueConfig(Config queueConfig) throws RMConfigException {
        this.maxAdmissibleQuery = queueConfig.hasPath(MAX_ADMISSIBLE_KEY) ? queueConfig.getInt(MAX_ADMISSIBLE_KEY) : 10;
        this.maxWaitingQuery = queueConfig.hasPath(MAX_WAITING_KEY) ? queueConfig.getInt(MAX_WAITING_KEY) : 10;
        this.maxWaitingTimeout = queueConfig.hasPath(MAX_WAIT_TIMEOUT_KEY) ? queueConfig.getInt(MAX_WAIT_TIMEOUT_KEY) : 30000;
        this.waitForPreferredNodes = queueConfig.hasPath(WAIT_FOR_PREFERRED_NODES_KEY) ? queueConfig.getBoolean(WAIT_FOR_PREFERRED_NODES_KEY) : true;
        this.queryPerNodeResourceShare = this.parseAndGetNodeShare(queueConfig);
    }

    @Override
    public String getQueueId() {
        return this.queueUUID;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public long getQueueTotalMemoryInMB(int numClusterNodes) {
        return this.queueResourceShare.getMemoryInMB() * (long)numClusterNodes;
    }

    @Override
    public long getMaxQueryMemoryInMBPerNode() {
        return this.queryPerNodeResourceShare.getMemoryInMB();
    }

    @Override
    public long getMaxQueryTotalMemoryInMB(int numClusterNodes) {
        return this.queryPerNodeResourceShare.getMemoryInMB() * (long)numClusterNodes;
    }

    @Override
    public boolean waitForPreferredNodes() {
        return this.waitForPreferredNodes;
    }

    @Override
    public int getMaxAdmissibleQueries() {
        return this.maxAdmissibleQuery;
    }

    @Override
    public int getMaxWaitingQueries() {
        return this.maxWaitingQuery;
    }

    @Override
    public int getWaitTimeoutInMs() {
        return this.maxWaitingTimeout;
    }

    private NodeResources parseAndGetNodeShare(Config queueConfig) throws RMConfigException {
        try {
            long memoryPerNodeInBytes = MemoryConfigParser.parseMemoryConfigString(queueConfig.getString(MAX_QUERY_MEMORY_PER_NODE_KEY), MAX_QUERY_MEMORY_PER_NODE_FORMAT);
            return new NodeResources(memoryPerNodeInBytes, Integer.MAX_VALUE);
        }
        catch (Exception ex) {
            throw new RMConfigException(String.format("Failed while parsing %s for queue %s", MAX_QUERY_MEMORY_PER_NODE_KEY, this.queueName), ex);
        }
    }

    public String toString() {
        return "{ QueueName: " + this.queueName + ", QueueId: " + this.queueUUID + ", QueuePerNodeResource(MB): " + this.queryPerNodeResourceShare.toString() + ", MaxQueryMemPerNode(MB): " + this.queryPerNodeResourceShare.toString() + ", MaxAdmissible: " + this.maxAdmissibleQuery + ", MaxWaiting: " + this.maxWaitingQuery + ", MaxWaitTimeout: " + this.maxWaitingTimeout + ", WaitForPreferredNodes: " + this.waitForPreferredNodes + "}";
    }
}

