/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.resourcemgr.config.selectors;

import com.typesafe.config.Config;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.resourcemgr.config.exception.RMConfigException;
import org.apache.drill.exec.resourcemgr.config.selectors.AbstractResourcePoolSelector;
import org.apache.drill.exec.resourcemgr.config.selectors.ResourcePoolSelector;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclSelector
extends AbstractResourcePoolSelector {
    private static final Logger logger = LoggerFactory.getLogger(AclSelector.class);
    private final Set<String> allowedUsers = Sets.newHashSet();
    private final Set<String> allowedGroups = Sets.newHashSet();
    private final Set<String> deniedUsers = Sets.newHashSet();
    private final Set<String> deniedGroups = Sets.newHashSet();
    private final Config aclSelectorValue;
    private static final String ACL_VALUE_GROUPS_KEY = "groups";
    private static final String ACL_VALUE_USERS_KEY = "users";
    private static final String ACL_LONG_SYNTAX_SEPARATOR = ":";
    private static final String ACL_LONG_ALLOWED_IDENTIFIER = "+";
    private static final String ACL_LONG_DISALLOWED_IDENTIFIER = "-";
    private static final String ACL_ALLOW_ALL = "*";

    AclSelector(Config configValue) throws RMConfigException {
        super(ResourcePoolSelector.SelectorType.ACL);
        this.aclSelectorValue = configValue;
        this.validateAndParseACL(this.aclSelectorValue);
    }

    @Override
    public boolean isQuerySelected(QueryContext queryContext) {
        String queryUser = queryContext.getQueryUserName();
        UserGroupInformation queryUserUGI = ImpersonationUtil.createProxyUgi(queryUser);
        HashSet<String> queryGroups = Sets.newHashSet(queryUserUGI.getGroupNames());
        return this.checkQueryUserGroups(queryUser, queryGroups);
    }

    @VisibleForTesting
    public boolean checkQueryUserGroups(String queryUser, Set<String> queryGroups) {
        if (this.deniedUsers.contains(queryUser)) {
            logger.debug("Query user is present in configured ACL -ve users list");
            return false;
        }
        if (this.allowedUsers.contains(queryUser)) {
            logger.debug("Query user is present in configured ACL +ve users list");
            return true;
        }
        if (this.isStarInDisAllowedUsersList()) {
            logger.debug("Query user is absent in configured ACL +ve/-ve users list but * is in -ve users list");
            return false;
        }
        if (this.isStarInAllowedUsersList()) {
            logger.debug("Query user is absent in configured ACL +ve/-ve users list but * is in +ve users list");
            return true;
        }
        if (Sets.intersection(queryGroups, this.deniedGroups).size() > 0) {
            logger.debug("Groups of Query user is present in configured ACL -ve groups list");
            return false;
        }
        if (Sets.intersection(queryGroups, this.allowedGroups).size() > 0) {
            logger.debug("Groups of Query user is present in configured ACL +ve groups list");
            return true;
        }
        if (this.isStarInDisAllowedGroupsList()) {
            logger.debug("Groups of Query user is absent in configured ACL +ve/-ve groups list but * is in -ve groups list");
            return false;
        }
        if (this.isStarInAllowedGroupsList()) {
            logger.debug("Groups of Query user is absent in configured ACL +ve/-ve groups list but * is in +ve groups list");
            return true;
        }
        logger.debug("Neither query user or group is present in configured ACL users/groups list");
        return false;
    }

    private void validateAndParseACL(Config aclConfig) throws RMConfigException {
        if (!aclConfig.hasPath(ACL_VALUE_GROUPS_KEY) && !aclConfig.hasPath(ACL_VALUE_USERS_KEY)) {
            throw new RMConfigException(String.format("ACL Selector config is missing both group and user list information. Please configure either of groups or users list. [Details: aclConfig: %s]", aclConfig));
        }
        if (aclConfig.hasPath(ACL_VALUE_USERS_KEY)) {
            List users = this.aclSelectorValue.getStringList(ACL_VALUE_USERS_KEY);
            this.parseACLInput(users, this.allowedUsers, this.deniedUsers);
        }
        if (aclConfig.hasPath(ACL_VALUE_GROUPS_KEY)) {
            List groups = this.aclSelectorValue.getStringList(ACL_VALUE_GROUPS_KEY);
            this.parseACLInput(groups, this.allowedGroups, this.deniedGroups);
        }
        if (this.allowedGroups.size() == 0 && this.deniedGroups.size() == 0 && this.deniedUsers.size() == 0 && this.allowedUsers.size() == 0) {
            throw new RMConfigException("No valid users or groups information is configured for this ACL selector. Either use * or valid users/groups");
        }
        Sets.SetView<String> wrongConfig = Sets.intersection(this.allowedUsers, this.deniedUsers);
        if (wrongConfig.size() > 0) {
            logger.warn("These users are configured both in allowed and disallowed list. They will be treated as disallowed. [Details: users: {}]", wrongConfig);
            this.allowedUsers.removeAll(wrongConfig);
        }
        if ((wrongConfig = Sets.intersection(this.allowedGroups, this.deniedGroups)).size() > 0) {
            logger.warn("These groups are configured both in allowed and disallowed list. They will be treated as disallowed. [Details: groups: {}]", wrongConfig);
            this.allowedGroups.removeAll(wrongConfig);
        }
    }

    public Set<String> getAllowedUsers() {
        return this.allowedUsers;
    }

    public Set<String> getAllowedGroups() {
        return this.allowedGroups;
    }

    public Set<String> getDeniedUsers() {
        return this.deniedUsers;
    }

    public Set<String> getDeniedGroups() {
        return this.deniedGroups;
    }

    private boolean isStarInAllowedUsersList() {
        return this.allowedUsers.contains(ACL_ALLOW_ALL);
    }

    private boolean isStarInAllowedGroupsList() {
        return this.allowedGroups.contains(ACL_ALLOW_ALL);
    }

    private boolean isStarInDisAllowedUsersList() {
        return this.deniedUsers.contains(ACL_ALLOW_ALL);
    }

    private boolean isStarInDisAllowedGroupsList() {
        return this.deniedGroups.contains(ACL_ALLOW_ALL);
    }

    private void parseACLInput(List<String> acls, Set<String> allowedIdentity, Set<String> disAllowedIdentity) {
        for (String aclValue : acls) {
            if (aclValue.isEmpty()) continue;
            String[] aclValueSplits = aclValue.split(ACL_LONG_SYNTAX_SEPARATOR);
            if (aclValueSplits.length == 1) {
                if (allowedIdentity.add(aclValueSplits[0])) continue;
                logger.info("Duplicate acl identity: {} found in configured list will be ignored", (Object)aclValueSplits[0]);
                continue;
            }
            String identifier = aclValueSplits[1];
            if (identifier.equals(ACL_LONG_ALLOWED_IDENTIFIER)) {
                if (allowedIdentity.add(aclValueSplits[0])) continue;
                logger.info("Duplicate acl identity: {} found in configured list will be ignored", (Object)aclValueSplits[0]);
                continue;
            }
            if (identifier.equals(ACL_LONG_DISALLOWED_IDENTIFIER)) {
                if (disAllowedIdentity.add(aclValueSplits[0])) continue;
                logger.info("Duplicate acl identity: {} found in configured list will be ignored", (Object)aclValueSplits[0]);
                continue;
            }
            logger.error("Invalid long form syntax encountered hence ignoring ACL string {} . Details[Allowed identifiers are `+` and `-`. Encountered: {}]", (Object)aclValue, (Object)identifier);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ SelectorType: ").append(super.toString());
        sb.append(", AllowedUsers: [");
        for (String positiveUser : this.allowedUsers) {
            sb.append(positiveUser).append(", ");
        }
        sb.append("], AllowedGroups: [");
        for (String positiveGroup : this.allowedGroups) {
            sb.append(positiveGroup).append(", ");
        }
        sb.append("], DisallowedUsers: [");
        for (String negativeUser : this.deniedUsers) {
            sb.append(negativeUser).append(", ");
        }
        sb.append("], DisallowedGroups: [");
        for (String negativeGroup : this.deniedGroups) {
            sb.append(negativeGroup).append(", ");
        }
        sb.append("]}");
        return sb.toString();
    }
}

