/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.resourcemgr.config.selectors;

import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.resourcemgr.config.exception.RMConfigException;
import org.apache.drill.exec.resourcemgr.config.selectors.AbstractResourcePoolSelector;
import org.apache.drill.exec.resourcemgr.config.selectors.ResourcePoolSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagSelector
extends AbstractResourcePoolSelector {
    private static final Logger logger = LoggerFactory.getLogger(TagSelector.class);
    private final String configuredTag;

    TagSelector(String selectorValue) throws RMConfigException {
        super(ResourcePoolSelector.SelectorType.TAG);
        if (selectorValue == null || selectorValue.isEmpty()) {
            throw new RMConfigException("Tag value of this selector is either null or empty. Please configure a valid tag as string.");
        }
        this.configuredTag = selectorValue;
    }

    @Override
    public ResourcePoolSelector.SelectorType getSelectorType() {
        return this.SELECTOR_TYPE;
    }

    @Override
    public boolean isQuerySelected(QueryContext queryContext) {
        String[] queryTags;
        for (String queryTag : queryTags = queryContext.getOption((String)"exec.rm.queryTags").string_val.split(",")) {
            if (!queryTag.equals(this.configuredTag)) continue;
            logger.debug("Query {} tag {} matches the selector tag {}", new Object[]{queryContext.getQueryId(), queryTag, this.configuredTag});
            return true;
        }
        return false;
    }

    public String getTagValue() {
        return this.configuredTag;
    }

    @Override
    public String toString() {
        return "{ SelectorType: " + super.toString() + ", TagValue: [" + this.configuredTag + "]}";
    }
}

