/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.resourcemgr.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MemoryConfigParser {
    public static long parseMemoryConfigString(String memoryConfig, String patternToUse) {
        Pattern pattern = Pattern.compile(patternToUse);
        Matcher patternMatcher = pattern.matcher(memoryConfig);
        long memoryPerNodeInBytes = 0L;
        if (patternMatcher.matches()) {
            memoryPerNodeInBytes = Long.parseLong(patternMatcher.group(1));
            String group2 = patternMatcher.group(2);
            if (!group2.isEmpty()) {
                switch (group2.charAt(0)) {
                    case 'G': 
                    case 'g': {
                        memoryPerNodeInBytes *= 0x40000000L;
                        break;
                    }
                    case 'K': 
                    case 'k': {
                        memoryPerNodeInBytes *= 1024L;
                        break;
                    }
                    case 'M': 
                    case 'm': {
                        memoryPerNodeInBytes *= 0x100000L;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("Memory Configuration %s didn't matched any of the supported suffixes. [Details: Supported: kKmMgG, Actual: %s", memoryConfig, group2));
                    }
                }
            }
        } else {
            throw new IllegalArgumentException(String.format("Memory Configuration %s didn't matched supported format. Supported format is %s?", memoryConfig, patternToUse));
        }
        return memoryPerNodeInBytes;
    }
}

