/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.control;

import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.rpc.BitRpcUtility;
import org.apache.drill.exec.rpc.control.ControlConnectionConfig;
import org.apache.drill.exec.rpc.control.ControlConnectionManager;
import org.apache.drill.exec.rpc.control.LocalControlConnectionManager;
import org.apache.drill.exec.rpc.control.RemoteControlConnectionManager;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManagerRegistry
implements Iterable<ControlConnectionManager> {
    static final Logger logger = LoggerFactory.getLogger(ConnectionManagerRegistry.class);
    private final ConcurrentMap<CoordinationProtos.DrillbitEndpoint, ControlConnectionManager> registry = Maps.newConcurrentMap();
    private final ControlConnectionConfig config;
    private CoordinationProtos.DrillbitEndpoint localEndpoint;

    public ConnectionManagerRegistry(ControlConnectionConfig config) {
        this.config = config;
    }

    public ControlConnectionManager getConnectionManager(CoordinationProtos.DrillbitEndpoint remoteEndpoint) {
        ControlConnectionManager m2;
        assert (this.localEndpoint != null) : "DrillbitEndpoint must be set before a connection manager can be retrieved";
        boolean isLocalServer = BitRpcUtility.isLocalControlServer(this.localEndpoint, remoteEndpoint);
        ControlConnectionManager m = (ControlConnectionManager)this.registry.get(remoteEndpoint);
        if (m == null && (m2 = this.registry.putIfAbsent(remoteEndpoint, m = isLocalServer ? new LocalControlConnectionManager(this.config, remoteEndpoint) : new RemoteControlConnectionManager(this.config, this.localEndpoint, remoteEndpoint))) != null) {
            m = m2;
        }
        return m;
    }

    void setLocalEndpoint(CoordinationProtos.DrillbitEndpoint endpoint) {
        this.localEndpoint = endpoint;
    }

    @Override
    public Iterator<ControlConnectionManager> iterator() {
        return this.registry.values().iterator();
    }
}

