/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.control;

import com.google.protobuf.MessageLite;
import io.netty.buffer.ByteBuf;
import io.netty.channel.socket.SocketChannel;
import java.util.UUID;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.rpc.AbstractServerConnection;
import org.apache.drill.exec.rpc.ClientConnection;
import org.apache.drill.exec.rpc.RequestHandler;
import org.apache.drill.exec.rpc.RpcBus;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.apache.drill.exec.rpc.SaslCodec;
import org.apache.drill.exec.rpc.control.ControlConnectionConfig;
import org.apache.drill.exec.rpc.control.ControlRpcMetrics;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlConnection
extends AbstractServerConnection<ControlConnection>
implements ClientConnection {
    private static final Logger logger = LoggerFactory.getLogger(ControlConnection.class);
    private final RpcBus<BitControl.RpcType, ControlConnection> bus;
    private final UUID id;
    private volatile CoordinationProtos.DrillbitEndpoint endpoint;
    private volatile boolean active = false;
    private SaslClient saslClient;

    ControlConnection(SocketChannel channel, String name, ControlConnectionConfig config, RequestHandler<ControlConnection> handler, RpcBus<BitControl.RpcType, ControlConnection> bus) {
        super(channel, name, config, handler);
        this.bus = bus;
        this.id = UUID.randomUUID();
    }

    void setEndpoint(CoordinationProtos.DrillbitEndpoint endpoint) {
        assert (this.endpoint == null) : "Endpoint should only be set once (only in the case in incoming server requests).";
        this.endpoint = endpoint;
        this.active = true;
    }

    public <SEND extends MessageLite, RECEIVE extends MessageLite> void send(RpcOutcomeListener<RECEIVE> outcomeListener, BitControl.RpcType rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        this.bus.send(outcomeListener, this, rpcType, protobufBody, clazz, dataBodies);
    }

    public <SEND extends MessageLite, RECEIVE extends MessageLite> void sendUnsafe(RpcOutcomeListener<RECEIVE> outcomeListener, BitControl.RpcType rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        this.bus.send(outcomeListener, this, rpcType, protobufBody, clazz, true, dataBodies);
    }

    @Override
    public boolean isActive() {
        return this.active && super.isActive();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ControlConnection other = (ControlConnection)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    public void setSaslClient(final SaslClient saslClient) {
        Preconditions.checkState(this.saslClient == null);
        this.saslClient = saslClient;
        if (this.isEncryptionEnabled()) {
            this.saslCodec = new SaslCodec(){

                @Override
                public byte[] wrap(byte[] data, int offset, int len) throws SaslException {
                    assert (saslClient != null);
                    return saslClient.wrap(data, offset, len);
                }

                @Override
                public byte[] unwrap(byte[] data, int offset, int len) throws SaslException {
                    assert (saslClient != null);
                    return saslClient.unwrap(data, offset, len);
                }
            };
        }
    }

    @Override
    public SaslClient getSaslClient() {
        Preconditions.checkState(this.saslClient != null);
        return this.saslClient;
    }

    @Override
    public void disposeSaslClient() {
        try {
            if (this.saslClient != null) {
                this.saslClient.dispose();
                this.saslClient = null;
            }
        }
        catch (SaslException e) {
            this.getLogger().warn("Unclean disposal", (Throwable)e);
        }
    }

    @Override
    public void channelClosed(RpcException ex) {
        this.disposeSaslClient();
        super.channelClosed(ex);
    }

    @Override
    public void incConnectionCounter() {
        ControlRpcMetrics.getInstance().addConnectionCount();
    }

    @Override
    public void decConnectionCounter() {
        ControlRpcMetrics.getInstance().decConnectionCount();
    }
}

