/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.data;

import io.netty.buffer.ByteBuf;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.drill.exec.proto.BitData;
import org.apache.drill.exec.rpc.Response;
import org.apache.drill.exec.rpc.ResponseSender;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;

public class AckSender {
    private AtomicInteger count = new AtomicInteger(0);
    private ResponseSender sender;
    private int everLargestAdviceCredit = 0;

    @VisibleForTesting
    public AckSender(ResponseSender sender) {
        this.sender = sender;
    }

    void increment() {
        this.count.incrementAndGet();
    }

    void clear() {
        this.count.set(-100000);
    }

    public void sendOk() {
        this.sendOk(0);
    }

    public void sendOk(int credit) {
        this.everLargestAdviceCredit = Math.max(this.everLargestAdviceCredit, credit);
        if (0 == this.count.decrementAndGet()) {
            BitData.AckWithCredit ackWithCredit = BitData.AckWithCredit.newBuilder().setAllowedCredit(this.everLargestAdviceCredit).build();
            Response ackResponse = new Response(BitData.RpcType.DATA_ACK_WITH_CREDIT, ackWithCredit, new ByteBuf[0]);
            this.sender.send(ackResponse);
        }
    }

    public void sendFail() {
        BitData.AckWithCredit ackWithCredit = BitData.AckWithCredit.newBuilder().setAllowedCredit(-1).build();
        Response ackFailResponse = new Response(BitData.RpcType.DATA_ACK_WITH_CREDIT, ackWithCredit, new ByteBuf[0]);
        this.sender.send(ackFailResponse);
    }
}

