/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.data;

import java.util.concurrent.ConcurrentMap;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.exception.DrillbitStartupException;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.rpc.control.WorkEventBus;
import org.apache.drill.exec.rpc.data.DataConnectionConfig;
import org.apache.drill.exec.rpc.data.DataConnectionManager;
import org.apache.drill.exec.rpc.data.DataRpcMetrics;
import org.apache.drill.exec.rpc.data.DataServer;
import org.apache.drill.exec.rpc.data.DataServerRequestHandler;
import org.apache.drill.exec.rpc.data.DataTunnel;
import org.apache.drill.exec.server.BootStrapContext;
import org.apache.drill.exec.work.WorkManager;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataConnectionCreator
implements AutoCloseable {
    static final Logger logger = LoggerFactory.getLogger(DataConnectionCreator.class);
    private volatile DataServer server;
    private final ConcurrentMap<CoordinationProtos.DrillbitEndpoint, DataConnectionManager> connectionManager = Maps.newConcurrentMap();
    private final DataConnectionConfig config;

    public DataConnectionCreator(BootStrapContext context, BufferAllocator allocator, WorkEventBus workBus, WorkManager.WorkerBee bee) throws DrillbitStartupException {
        this.config = new DataConnectionConfig(allocator, context, new DataServerRequestHandler(workBus, bee));
        ((DataRpcMetrics)DataRpcMetrics.getInstance()).initialize(this.config.isEncryptionEnabled(), allocator);
    }

    public CoordinationProtos.DrillbitEndpoint start(CoordinationProtos.DrillbitEndpoint partialEndpoint, boolean allowPortHunting) {
        this.server = new DataServer(this.config);
        int port = partialEndpoint.getControlPort() + 1;
        DrillConfig drillConfig = this.config.getBootstrapContext().getConfig();
        String bindAddr = drillConfig.getString("drill.exec.rpc.bind_addr");
        if (drillConfig.hasPath("drill.exec.rpc.bit.server.dataport")) {
            port = drillConfig.getInt("drill.exec.rpc.bit.server.dataport");
        }
        port = this.server.bind(bindAddr, port, allowPortHunting);
        return partialEndpoint.toBuilder().setDataPort(port).build();
    }

    public DataTunnel getTunnel(CoordinationProtos.DrillbitEndpoint endpoint) {
        DataConnectionManager newManager = new DataConnectionManager(endpoint, this.config);
        DataConnectionManager oldManager = this.connectionManager.putIfAbsent(endpoint, newManager);
        if (oldManager != null) {
            newManager = oldManager;
        }
        return new DataTunnel(newManager);
    }

    @Override
    public void close() throws Exception {
        AutoCloseables.close(this.server, this.config.getAllocator());
    }
}

