/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.data;

import io.netty.buffer.ByteBuf;
import java.util.concurrent.Executor;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.proto.BitData;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.Acks;
import org.apache.drill.exec.rpc.Response;
import org.apache.drill.exec.rpc.RpcConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataRpcConfig {
    static final Logger logger = LoggerFactory.getLogger(DataRpcConfig.class);
    public static int RPC_VERSION = 4;
    public static final Response OK = new Response(BitData.RpcType.ACK, Acks.OK, new ByteBuf[0]);
    public static final Response FAIL = new Response(BitData.RpcType.ACK, Acks.FAIL, new ByteBuf[0]);

    public static RpcConfig getMapping(DrillConfig config, Executor executor) {
        return RpcConfig.newBuilder().name("DATA").executor(executor).timeout(config.getInt("drill.exec.rpc.bit.timeout")).add(BitData.RpcType.HANDSHAKE, BitData.BitClientHandshake.class, BitData.RpcType.HANDSHAKE, BitData.BitServerHandshake.class).add(BitData.RpcType.REQ_RECORD_BATCH, BitData.FragmentRecordBatch.class, BitData.RpcType.DATA_ACK_WITH_CREDIT, BitData.AckWithCredit.class).add(BitData.RpcType.SASL_MESSAGE, UserBitShared.SaslMessage.class, BitData.RpcType.SASL_MESSAGE, UserBitShared.SaslMessage.class).add(BitData.RpcType.REQ_RUNTIME_FILTER, BitData.RuntimeFilterBDef.class, BitData.RpcType.DATA_ACK_WITH_CREDIT, BitData.AckWithCredit.class).build();
    }
}

