/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.data;

import com.google.protobuf.Internal;
import com.google.protobuf.MessageLite;
import io.netty.channel.ChannelFuture;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.BitData;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.BasicServer;
import org.apache.drill.exec.rpc.OutOfMemoryHandler;
import org.apache.drill.exec.rpc.ProtobufLengthDecoder;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.data.DataConnectionConfig;
import org.apache.drill.exec.rpc.data.DataDefaultInstanceHandler;
import org.apache.drill.exec.rpc.data.DataProtobufLengthDecoder;
import org.apache.drill.exec.rpc.data.DataRpcConfig;
import org.apache.drill.exec.rpc.data.DataServerConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataServer
extends BasicServer<BitData.RpcType, DataServerConnection> {
    private static final Logger logger = LoggerFactory.getLogger(DataServer.class);
    private final DataConnectionConfig config;

    public DataServer(DataConnectionConfig config) {
        super(DataRpcConfig.getMapping(config.getBootstrapContext().getConfig(), config.getBootstrapContext().getExecutor()), config.getAllocator().getAsByteBufAllocator(), config.getBootstrapContext().getDataServerLoopGroup());
        this.config = config;
    }

    @Override
    public MessageLite getResponseDefaultInstance(int rpcType) throws RpcException {
        return DataDefaultInstanceHandler.getResponseDefaultInstanceServer(rpcType);
    }

    @Override
    protected GenericFutureListener<ChannelFuture> getCloseHandler(SocketChannel ch, DataServerConnection connection) {
        return new ProxyCloseHandler(super.getCloseHandler(ch, connection));
    }

    @Override
    protected DataServerConnection initRemoteConnection(SocketChannel channel) {
        super.initRemoteConnection(channel);
        DataServerConnection dataServerConnection = new DataServerConnection(channel, this.config);
        dataServerConnection.incConnectionCounter();
        return dataServerConnection;
    }

    @Override
    protected BasicServer.ServerHandshakeHandler<BitData.BitClientHandshake> getHandshakeHandler(DataServerConnection connection) {
        return new BasicServer.ServerHandshakeHandler<BitData.BitClientHandshake>((Internal.EnumLite)BitData.RpcType.HANDSHAKE, BitData.BitClientHandshake.PARSER){

            @Override
            public MessageLite getHandshakeResponse(BitData.BitClientHandshake inbound) throws Exception {
                if (inbound.getRpcVersion() != DataRpcConfig.RPC_VERSION) {
                    throw new RpcException(String.format("Invalid rpc version.  Expected %d, actual %d.", inbound.getRpcVersion(), DataRpcConfig.RPC_VERSION));
                }
                if (inbound.getChannel() != UserBitShared.RpcChannel.BIT_DATA) {
                    throw new RpcException(String.format("Invalid NodeMode.  Expected BIT_DATA but received %s.", inbound.getChannel()));
                }
                BitData.BitServerHandshake.Builder builder = BitData.BitServerHandshake.newBuilder();
                builder.setRpcVersion(DataRpcConfig.RPC_VERSION);
                if (DataServer.this.config.getAuthMechanismToUse() != null) {
                    builder.addAllAuthenticationMechanisms(DataServer.this.config.getAuthProvider().getAllFactoryNames());
                }
                return builder.build();
            }
        };
    }

    @Override
    protected OutOfMemoryHandler getOutOfMemoryHandler() {
        return new OutOfMemoryHandler(){

            @Override
            public void handle() {
                logger.error("Out of memory in RPC layer.");
            }
        };
    }

    @Override
    protected ProtobufLengthDecoder getDecoder(BufferAllocator allocator, OutOfMemoryHandler outOfMemoryHandler) {
        return new DataProtobufLengthDecoder.Server(allocator, outOfMemoryHandler);
    }

    private class ProxyCloseHandler
    implements GenericFutureListener<ChannelFuture> {
        private volatile GenericFutureListener<ChannelFuture> handler;

        public ProxyCloseHandler(GenericFutureListener<ChannelFuture> handler) {
            this.handler = handler;
        }

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            this.handler.operationComplete(future);
        }
    }
}

