/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.user;

import io.netty.buffer.DrillBuf;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.drill.exec.proto.UserBitShared;

public class QueryDataBatch {
    private final UserBitShared.QueryData header;
    private final DrillBuf data;
    private final AtomicBoolean released = new AtomicBoolean(false);

    public QueryDataBatch(UserBitShared.QueryData header, DrillBuf data) {
        this.header = header;
        this.data = data;
        if (this.data != null) {
            data.retain(1);
        }
    }

    public UserBitShared.QueryData getHeader() {
        return this.header;
    }

    public DrillBuf getData() {
        return this.data;
    }

    public boolean hasData() {
        return this.data != null;
    }

    public void release() {
        if (!this.released.compareAndSet(false, true)) {
            throw new IllegalStateException("QueryDataBatch was released twice.");
        }
        if (this.data != null) {
            this.data.release(1);
        }
    }

    public String toString() {
        return "QueryResultBatch [header=" + this.header + ", data=" + this.data + "]";
    }
}

