/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.user;

import com.google.protobuf.InvalidProtocolBufferException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.exec.rpc.RequestHandler;
import org.apache.drill.exec.rpc.Response;
import org.apache.drill.exec.rpc.ResponseSender;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.work.user.UserWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserServerRequestHandler
implements RequestHandler<UserServer.BitToUserConnection> {
    private static final Logger logger = LoggerFactory.getLogger(UserServerRequestHandler.class);
    private final UserWorker worker;

    public UserServerRequestHandler(UserWorker worker) {
        this.worker = worker;
    }

    @Override
    public void handle(UserServer.BitToUserConnection connection, int rpcType, ByteBuf pBody, ByteBuf dBody, ResponseSender responseSender) throws RpcException {
        switch (rpcType) {
            case 3: {
                logger.debug("Received query to run.  Returning query handle.");
                try {
                    UserProtos.RunQuery query = UserProtos.RunQuery.PARSER.parseFrom(new ByteBufInputStream(pBody));
                    UserBitShared.QueryId queryId = this.worker.submitWork(connection, query);
                    responseSender.send(new Response(UserProtos.RpcType.QUERY_HANDLE, queryId, new ByteBuf[0]));
                    break;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RpcException("Failure while decoding RunQuery body.", e);
                }
            }
            case 4: {
                try {
                    UserBitShared.QueryId queryId = UserBitShared.QueryId.PARSER.parseFrom(new ByteBufInputStream(pBody));
                    GeneralRPCProtos.Ack ack = this.worker.cancelQuery(queryId);
                    responseSender.send(new Response(UserProtos.RpcType.ACK, ack, new ByteBuf[0]));
                    break;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RpcException("Failure while decoding QueryId body.", e);
                }
            }
            case 11: {
                try {
                    UserBitShared.QueryId queryId = UserBitShared.QueryId.PARSER.parseFrom(new ByteBufInputStream(pBody));
                    GeneralRPCProtos.Ack ack = this.worker.resumeQuery(queryId);
                    responseSender.send(new Response(UserProtos.RpcType.ACK, ack, new ByteBuf[0]));
                    break;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RpcException("Failure while decoding QueryId body.", e);
                }
            }
            case 12: {
                try {
                    UserProtos.GetQueryPlanFragments req = UserProtos.GetQueryPlanFragments.PARSER.parseFrom(new ByteBufInputStream(pBody));
                    responseSender.send(new Response(UserProtos.RpcType.QUERY_PLAN_FRAGMENTS, this.worker.getQueryPlan(connection, req), new ByteBuf[0]));
                    break;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RpcException("Failure while decoding GetQueryPlanFragments body.", e);
                }
            }
            case 14: {
                try {
                    UserProtos.GetCatalogsReq req = UserProtos.GetCatalogsReq.PARSER.parseFrom(new ByteBufInputStream(pBody));
                    this.worker.submitCatalogMetadataWork(connection.getSession(), req, responseSender);
                    break;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RpcException("Failure while decoding GetCatalogsReq body.", e);
                }
            }
            case 15: {
                try {
                    UserProtos.GetSchemasReq req = UserProtos.GetSchemasReq.PARSER.parseFrom(new ByteBufInputStream(pBody));
                    this.worker.submitSchemasMetadataWork(connection.getSession(), req, responseSender);
                    break;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RpcException("Failure while decoding GetSchemasReq body.", e);
                }
            }
            case 16: {
                try {
                    UserProtos.GetTablesReq req = UserProtos.GetTablesReq.PARSER.parseFrom(new ByteBufInputStream(pBody));
                    this.worker.submitTablesMetadataWork(connection.getSession(), req, responseSender);
                    break;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RpcException("Failure while decoding GetTablesReq body.", e);
                }
            }
            case 17: {
                try {
                    UserProtos.GetColumnsReq req = UserProtos.GetColumnsReq.PARSER.parseFrom(new ByteBufInputStream(pBody));
                    this.worker.submitColumnsMetadataWork(connection.getSession(), req, responseSender);
                    break;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RpcException("Failure while decoding GetColumnsReq body.", e);
                }
            }
            case 22: {
                try {
                    UserProtos.CreatePreparedStatementReq req = UserProtos.CreatePreparedStatementReq.PARSER.parseFrom(new ByteBufInputStream(pBody));
                    this.worker.submitPreparedStatementWork(connection, req, responseSender);
                    break;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RpcException("Failure while decoding CreatePreparedStatementReq body.", e);
                }
            }
            case 8: {
                try {
                    UserProtos.GetServerMetaReq req = UserProtos.GetServerMetaReq.PARSER.parseFrom(new ByteBufInputStream(pBody));
                    this.worker.submitServerMetadataWork(connection.getSession(), req, responseSender);
                    break;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RpcException("Failure while decoding CreatePreparedStatementReq body.", e);
                }
            }
            default: {
                throw new UnsupportedOperationException(String.format("UserServerRequestHandler received rpc of unknown type. Type was %d.", rpcType));
            }
        }
    }
}

