/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.user.security;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.digest.Md5Crypt;
import org.apache.commons.io.Charsets;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.exception.DrillbitStartupException;
import org.apache.drill.exec.rpc.user.security.UserAuthenticationException;
import org.apache.drill.exec.rpc.user.security.UserAuthenticator;
import org.apache.drill.exec.rpc.user.security.UserAuthenticatorTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UserAuthenticatorTemplate(type="htpasswd")
public class HtpasswdFileUserAuthenticator
implements UserAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(HtpasswdFileUserAuthenticator.class);
    private static final Pattern HTPASSWD_LINE_PATTERN = Pattern.compile("^([^:]+):([^:]+)");
    public static final String DEFAULT_HTPASSWD_AUTHENTICATOR_PATH = "/opt/drill/conf/htpasswd";
    private String path = "/opt/drill/conf/htpasswd";
    private long lastModified;
    private long lastFileSize;
    private Map<String, String> userToPassword;

    @Override
    public void setup(DrillConfig drillConfig) throws DrillbitStartupException {
        if (drillConfig.hasPath("drill.exec.security.user.auth.htpasswd.path")) {
            this.path = drillConfig.getString("drill.exec.security.user.auth.htpasswd.path");
        }
    }

    public static boolean isPasswordValid(String password, String hash) {
        if (hash.startsWith("$apr1$")) {
            return hash.equals(Md5Crypt.apr1Crypt((String)password, (String)hash));
        }
        if (hash.startsWith("$1$")) {
            return hash.equals(Md5Crypt.md5Crypt((byte[])password.getBytes(Charsets.UTF_8), (String)hash));
        }
        if (hash.startsWith("{SHA}")) {
            return hash.substring(5).equals(Base64.getEncoder().encodeToString(DigestUtils.sha1((String)password)));
        }
        if (hash.startsWith("$2y$")) {
            return false;
        }
        return hash.equals(password);
    }

    @Override
    public void authenticate(String username, String password) throws UserAuthenticationException {
        boolean credentialsAccepted;
        this.read();
        String hash = this.userToPassword.get(username);
        boolean bl = credentialsAccepted = hash != null && HtpasswdFileUserAuthenticator.isPasswordValid(password, hash);
        if (!credentialsAccepted) {
            throw new UserAuthenticationException(String.format("htpasswd auth failed for user '%s'", username));
        }
    }

    protected synchronized void read() {
        long newFileSize;
        File file = new File(this.path);
        long newLastModified = file.exists() ? file.lastModified() : 0L;
        long l = newFileSize = file.exists() ? file.length() : 0L;
        if (this.userToPassword == null || newLastModified != this.lastModified || newFileSize != this.lastFileSize) {
            HashMap<String, String> newMap = new HashMap<String, String>();
            if (newFileSize != 0L) {
                try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        Matcher m;
                        if (line.isEmpty() || line.startsWith("#") || !(m = HTPASSWD_LINE_PATTERN.matcher(line)).matches()) continue;
                        newMap.put(m.group(1), m.group(2));
                    }
                }
                catch (Exception e) {
                    logger.error(MessageFormat.format("Failed to read htpasswd file at path {0}", file), (Throwable)e);
                }
            } else {
                logger.error(MessageFormat.format("Empty or missing htpasswd file at path {0}", file));
            }
            this.lastFileSize = newFileSize;
            this.lastModified = newLastModified;
            this.userToPassword = newMap;
        }
    }

    @Override
    public void close() {
        this.lastModified = 0L;
        this.userToPassword = null;
    }
}

