/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.user.security;

import java.io.IOException;
import java.util.List;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.exception.DrillbitStartupException;
import org.apache.drill.exec.rpc.user.security.UserAuthenticationException;
import org.apache.drill.exec.rpc.user.security.UserAuthenticator;
import org.apache.drill.exec.rpc.user.security.UserAuthenticatorTemplate;
import org.jvnet.libpam.PAM;
import org.jvnet.libpam.PAMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UserAuthenticatorTemplate(type="pam4j")
public class Pam4jUserAuthenticator
implements UserAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(Pam4jUserAuthenticator.class);
    private List<String> profiles;

    @Override
    public void setup(DrillConfig drillConfig) throws DrillbitStartupException {
        this.profiles = drillConfig.getStringList("drill.exec.security.user.auth.pam_profiles");
    }

    @Override
    public void authenticate(String user, String password) throws UserAuthenticationException {
        for (String profile : this.profiles) {
            PAM pam = null;
            try {
                pam = new PAM(profile);
                pam.authenticate(user, password);
            }
            catch (PAMException ex) {
                logger.error("PAM auth failed for user: {} against {} profile. Exception: {}", new Object[]{user, profile, ex.getMessage()});
                throw new UserAuthenticationException(String.format("PAM auth failed for user: %s using profile: %s", user, profile));
            }
            finally {
                if (pam != null) {
                    pam.dispose();
                }
            }
            logger.trace("PAM authentication was successful for user: {} using profile: {}", (Object)user, (Object)profile);
        }
    }

    @Override
    public void close() throws IOException {
    }
}

