/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.user.security;

import com.bettercloud.vault.Vault;
import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import com.bettercloud.vault.response.LookupResponse;
import java.io.IOException;
import java.util.Objects;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.exception.DrillbitStartupException;
import org.apache.drill.exec.rpc.user.security.UserAuthenticationException;
import org.apache.drill.exec.rpc.user.security.UserAuthenticator;
import org.apache.drill.exec.rpc.user.security.UserAuthenticatorTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UserAuthenticatorTemplate(type="vault")
public class VaultUserAuthenticator
implements UserAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(VaultUserAuthenticator.class);
    public static final String VAULT_ADDRESS = "drill.exec.security.user.auth.vault.address";
    public static final String VAULT_AUTH_METHOD = "drill.exec.security.user.auth.vault.method";
    private VaultConfig vaultConfig;
    private Vault vault;
    private VaultAuthMethod authMethod;

    @Override
    public void setup(DrillConfig config) throws DrillbitStartupException {
        String vaultAddress = Objects.requireNonNull(config.getString(VAULT_ADDRESS), String.format("Vault address BOOT option is not specified. Please set [%s] config option.", VAULT_ADDRESS));
        this.authMethod = VaultAuthMethod.valueOf(Objects.requireNonNull(config.getString(VAULT_AUTH_METHOD), String.format("Vault auth method is not specified. Please set [%s] config option.", VAULT_AUTH_METHOD)));
        VaultConfig vaultConfBuilder = new VaultConfig().address(vaultAddress);
        try {
            logger.debug("Tries to init a Vault client with Vault addr = {}, auth method = {}", (Object)vaultAddress, (Object)this.authMethod);
            this.vaultConfig = vaultConfBuilder.build();
            this.vault = new Vault(this.vaultConfig);
        }
        catch (VaultException e) {
            logger.error(String.join((CharSequence)System.lineSeparator(), "Error initialising the Vault client library using configuration: ", "\tvaultAddress: {}", "\tauthMethod: {}"), new Object[]{vaultAddress, this.authMethod, e});
            throw new DrillbitStartupException("Error initialising the Vault client library: " + e.getMessage(), e);
        }
    }

    @Override
    public void authenticate(String user, String password) throws UserAuthenticationException {
        try {
            logger.debug("Tries to authenticate user {} using {}", (Object)user, (Object)this.authMethod);
            switch (this.authMethod) {
                case APP_ROLE: {
                    this.vault.auth().loginByAppRole(user, password);
                    break;
                }
                case LDAP: {
                    this.vault.auth().loginByLDAP(user, password);
                    break;
                }
                case USER_PASS: {
                    this.vault.auth().loginByUserPass(user, password);
                    break;
                }
                case VAULT_TOKEN: {
                    VaultConfig lookupConfig = new VaultConfig().address(this.vaultConfig.getAddress()).token(password).build();
                    LookupResponse lookupResp = new Vault(lookupConfig).auth().lookupSelf();
                    if (!lookupResp.getPath().endsWith("/" + user)) {
                        throw new UserAuthenticationException(String.format("Attempted to authenticate user %s with a Vault token that is  valid but has path %s!", user, lookupResp.getPath()));
                    }
                    break;
                }
                default: {
                    throw new UserAuthenticationException(String.format("The Vault authentication method '%s' is not supported", new Object[]{this.authMethod}));
                }
            }
        }
        catch (VaultException e) {
            logger.warn("Failed to authenticate user {} using {}: {}.", new Object[]{user, this.authMethod, e});
            throw new UserAuthenticationException(String.format("Failed to authenticate user %s using %s: %s", new Object[]{user, this.authMethod, e.getMessage()}));
        }
        logger.info("User {} authenticated against Vault successfully.", (Object)user);
    }

    @Override
    public void close() throws IOException {
        this.vault = null;
        logger.debug("Has been closed.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VaultUserAuthenticator that = (VaultUserAuthenticator)o;
        return Objects.equals(this.vaultConfig, that.vaultConfig) && Objects.equals(this.vault, that.vault) && this.authMethod == that.authMethod;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.vaultConfig, this.vault, this.authMethod});
    }

    public static enum VaultAuthMethod {
        APP_ROLE,
        LDAP,
        USER_PASS,
        VAULT_TOKEN;

    }
}

