/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.schema;

import java.util.Objects;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.schema.RecordSchema;
import org.apache.drill.shaded.guava.com.google.common.base.MoreObjects;
import org.apache.drill.shaded.guava.com.google.common.base.Strings;

public abstract class Field {
    final String prefixFieldName;
    TypeProtos.MajorType fieldType;
    RecordSchema schema;
    RecordSchema parentSchema;
    boolean read;

    public Field(RecordSchema parentSchema, TypeProtos.MajorType type, String prefixFieldName) {
        this.fieldType = type;
        this.prefixFieldName = prefixFieldName;
        this.parentSchema = parentSchema;
    }

    public abstract String getFieldName();

    public String getFullFieldName() {
        String fieldName = this.getFieldName();
        if (Strings.isNullOrEmpty(this.prefixFieldName)) {
            return fieldName;
        }
        if (Strings.isNullOrEmpty(fieldName)) {
            return this.prefixFieldName;
        }
        return this.prefixFieldName + "." + this.getFieldName();
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    protected abstract MoreObjects.ToStringHelper addAttributesToHelper(MoreObjects.ToStringHelper var1);

    MoreObjects.ToStringHelper getAttributesStringHelper() {
        return MoreObjects.toStringHelper(this).add("type", this.fieldType).add("fullFieldName", this.getFullFieldName()).add("schema", this.schema == null ? null : this.schema.toSchemaString()).omitNullValues();
    }

    public String toString() {
        return this.addAttributesToHelper(this.getAttributesStringHelper()).toString();
    }

    public RecordSchema getAssignedSchema() {
        return this.schema;
    }

    public void assignSchemaIfNull(RecordSchema newSchema) {
        if (!this.hasSchema()) {
            this.schema = newSchema;
        }
    }

    public boolean isRead() {
        return this.read;
    }

    public boolean hasSchema() {
        return this.schema != null;
    }

    public TypeProtos.MajorType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(TypeProtos.MajorType fieldType) {
        this.fieldType = fieldType;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        Field thatField = (Field)that;
        return Objects.equals(this.getFullFieldName(), thatField.getFullFieldName());
    }

    public int hashCode() {
        return this.getFullFieldName().hashCode();
    }
}

