/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.exec.serialization.InstanceSerializer;
import org.apache.drill.shaded.guava.com.google.common.base.Objects;

public class JacksonSerializer<T>
implements InstanceSerializer<T> {
    private static final ObjectMapper DEFAULT_MAPPER = JacksonUtils.createObjectMapper();
    private final ObjectReader reader;
    private final ObjectWriter writer;

    public JacksonSerializer(Class<T> klazz) {
        this.reader = DEFAULT_MAPPER.readerFor(klazz);
        this.writer = DEFAULT_MAPPER.writer();
    }

    public JacksonSerializer(ObjectMapper mapper, Class<T> klazz) {
        this.reader = mapper.readerFor(klazz);
        this.writer = mapper.writer();
    }

    @Override
    public T deserialize(byte[] raw) throws IOException {
        return (T)this.reader.readValue(raw);
    }

    @Override
    public byte[] serialize(T instance) throws IOException {
        return this.writer.writeValueAsBytes(instance);
    }

    public boolean equals(Object obj) {
        if (obj instanceof JacksonSerializer && obj.getClass().equals(this.getClass())) {
            JacksonSerializer other = (JacksonSerializer)obj;
            return Objects.equal(this.reader, other.reader) && Objects.equal(this.writer, other.writer);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.reader, this.writer);
    }
}

