/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server;

import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.coord.ClusterCoordinator;
import org.apache.drill.exec.coord.store.TransientStore;
import org.apache.drill.exec.coord.store.TransientStoreConfig;
import org.apache.drill.exec.proto.SchemaUserBitShared;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.store.sys.PersistentStore;
import org.apache.drill.exec.store.sys.PersistentStoreConfig;
import org.apache.drill.exec.store.sys.PersistentStoreProvider;

public class QueryProfileStoreContext {
    private static final String PROFILES = "profiles";
    private static final String RUNNING = "running";
    private final PersistentStore<UserBitShared.QueryProfile> completedProfiles;
    private final TransientStore<UserBitShared.QueryInfo> runningProfiles;
    private final PersistentStoreConfig<UserBitShared.QueryProfile> profileStoreConfig = PersistentStoreConfig.newProtoBuilder(SchemaUserBitShared.QueryProfile.WRITE, SchemaUserBitShared.QueryProfile.MERGE).name("profiles").blob().build();

    public QueryProfileStoreContext(DrillConfig config, PersistentStoreProvider storeProvider, ClusterCoordinator coordinator) {
        try {
            this.completedProfiles = storeProvider.getOrCreateStore(this.profileStoreConfig);
        }
        catch (Exception e) {
            throw new DrillRuntimeException(e);
        }
        this.runningProfiles = coordinator.getOrCreateTransientStore(TransientStoreConfig.newProtoBuilder(SchemaUserBitShared.QueryInfo.WRITE, SchemaUserBitShared.QueryInfo.MERGE).name(RUNNING).build());
    }

    public PersistentStoreConfig<UserBitShared.QueryProfile> getProfileStoreConfig() {
        return this.profileStoreConfig;
    }

    public PersistentStore<UserBitShared.QueryProfile> getCompletedProfileStore() {
        return this.completedProfiles;
    }

    public TransientStore<UserBitShared.QueryInfo> getRunningProfileStore() {
        return this.runningProfiles;
    }
}

