/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Parameters(separators="=")
public class StartupOptions {
    static final Logger logger = LoggerFactory.getLogger(StartupOptions.class);
    @Parameter(names={"-h", "--help"}, description="Provide description of usage.", help=true)
    private boolean help = false;
    @Parameter(names={"-d", "--debug"}, description="Whether you want to run the program in debug mode.", required=false)
    private boolean debug = false;
    @Parameter(names={"-c", "--config"}, description="Configuration file you want to load.  Defaults to loading 'drill-override.conf' from the classpath.", required=false)
    private String configLocation = null;
    @Parameter
    private List<String> exccess = new ArrayList<String>();

    public boolean isDebug() {
        return this.debug;
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public List<String> getExccess() {
        return this.exccess;
    }

    public static StartupOptions parse(String[] cliArgs) {
        logger.debug("Parsing arguments.");
        StartupOptions args = new StartupOptions();
        JCommander jc = new JCommander((Object)args, cliArgs);
        if (args.help) {
            jc.usage();
            System.exit(0);
        }
        return args;
    }
}

