/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.options;

import java.time.format.DateTimeFormatter;
import java.util.Set;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.server.options.OptionMetaData;
import org.apache.drill.exec.server.options.OptionSet;
import org.apache.drill.exec.server.options.OptionValidator;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.shaded.guava.com.google.common.base.Joiner;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeValidators {
    private static final Logger logger = LoggerFactory.getLogger(TypeValidators.class);

    public static abstract class TypeValidator
    extends OptionValidator {
        private final OptionValue.Kind kind;

        public TypeValidator(String name, OptionValue.Kind kind, OptionValidator.OptionDescription description) {
            super(name, description);
            this.kind = kind;
        }

        @Override
        public void validate(OptionValue v, OptionMetaData metaData, OptionSet manager) {
            if (v.kind != this.kind) {
                throw UserException.validationError().message(String.format("Option %s must be of type %s but you tried to set to %s.", this.getOptionName(), this.kind.name(), v.kind.name()), new Object[0]).build(logger);
            }
        }

        @Override
        public OptionValue.Kind getKind() {
            return this.kind;
        }

        @Override
        public String getConfigProperty() {
            return ExecConstants.bootDefaultFor(this.getOptionName());
        }
    }

    public static class DateTimeFormatValidator
    extends StringValidator {
        public DateTimeFormatValidator(String name, OptionValidator.OptionDescription description) {
            super(name, description);
        }

        @Override
        public void validate(OptionValue v, OptionMetaData metaData, OptionSet manager) {
            super.validate(v, metaData, manager);
            if (!v.string_val.isEmpty()) {
                try {
                    DateTimeFormatter.ofPattern(v.string_val);
                }
                catch (IllegalArgumentException e) {
                    throw UserException.validationError().message("'%s' is not a valid DateTime format pattern: %s", v.string_val, e.getMessage()).build(logger);
                }
            }
        }
    }

    public static class MaxWidthValidator
    extends LongValidator {
        public MaxWidthValidator(String name, OptionValidator.OptionDescription description) {
            super(name, description);
        }

        public int computeMaxWidth(double cpuLoadAverage, long maxWidth) {
            if (maxWidth != 0L) {
                return (int)maxWidth;
            }
            int availProc = Runtime.getRuntime().availableProcessors();
            long maxWidthPerNode = Math.max(1L, Math.min((long)availProc, Math.round((double)availProc * cpuLoadAverage)));
            return (int)maxWidthPerNode;
        }
    }

    public static class AdminUserGroupsValidator
    extends StringValidator {
        public final String DEFAULT_ADMIN_USER_GROUPS = "%drill_process_user_groups%";

        public AdminUserGroupsValidator(String name, OptionValidator.OptionDescription description) {
            super(name, description);
        }

        public String getAdminUserGroups(OptionSet optionManager) {
            String adminUserGroups = optionManager.getOption(ExecConstants.ADMIN_USER_GROUPS_VALIDATOR);
            if (adminUserGroups.equals("%drill_process_user_groups%")) {
                adminUserGroups = Joiner.on(",").join(ImpersonationUtil.getProcessUserGroupNames());
            }
            adminUserGroups = DrillStringUtils.sanitizeCSV(adminUserGroups);
            return adminUserGroups;
        }
    }

    public static class AdminUsersValidator
    extends StringValidator {
        public final String DEFAULT_ADMIN_USERS = "%drill_process_user%";

        public AdminUsersValidator(String name, OptionValidator.OptionDescription description) {
            super(name, description);
        }

        public String getAdminUsers(OptionSet optionManager) {
            String adminUsers = optionManager.getOption(ExecConstants.ADMIN_USERS_VALIDATOR);
            if (adminUsers.equals("%drill_process_user%")) {
                adminUsers = ImpersonationUtil.getProcessUserName();
            }
            adminUsers = DrillStringUtils.sanitizeCSV(adminUsers);
            return adminUsers;
        }
    }

    public static class EnumeratedStringValidator
    extends StringValidator {
        private final Set<String> valuesSet = Sets.newLinkedHashSet();

        public EnumeratedStringValidator(String name, OptionValidator.OptionDescription description, String ... values) {
            super(name, description);
            for (String value : values) {
                this.valuesSet.add(value.toLowerCase());
            }
        }

        @Override
        public void validate(OptionValue v, OptionMetaData metaData, OptionSet manager) {
            super.validate(v, metaData, manager);
            if (!this.valuesSet.contains(v.string_val.toLowerCase())) {
                throw UserException.validationError().message(String.format("Option %s must be one of: %s.", this.getOptionName(), this.valuesSet), new Object[0]).build(logger);
            }
        }
    }

    public static class RangeLongValidator
    extends LongValidator {
        private final long min;
        private final long max;

        public RangeLongValidator(String name, long min, long max, OptionValidator.OptionDescription description) {
            super(name, description);
            this.min = min;
            this.max = max;
        }

        @Override
        public void validate(OptionValue v, OptionMetaData metaData, OptionSet manager) {
            super.validate(v, metaData, manager);
            if (v.num_val > this.max || v.num_val < this.min) {
                throw UserException.validationError().message(String.format("Option %s must be between %d and %d.", this.getOptionName(), this.min, this.max), new Object[0]).build(logger);
            }
        }
    }

    public static class IntegerValidator
    extends LongValidator {
        public IntegerValidator(String name, OptionValidator.OptionDescription description) {
            super(name, description);
        }

        @Override
        public void validate(OptionValue v, OptionMetaData metaData, OptionSet manager) {
            super.validate(v, metaData, manager);
            if (v.num_val > Integer.MAX_VALUE || v.num_val < Integer.MIN_VALUE) {
                throw UserException.validationError().message(String.format("Option %s does not have a valid integer value", this.getOptionName()), new Object[0]).build(logger);
            }
        }
    }

    public static class DoubleValidator
    extends TypeValidator {
        public DoubleValidator(String name, OptionValidator.OptionDescription description) {
            super(name, OptionValue.Kind.DOUBLE, description);
        }
    }

    public static class LongValidator
    extends TypeValidator {
        public LongValidator(String name, OptionValidator.OptionDescription description) {
            super(name, OptionValue.Kind.LONG, description);
        }
    }

    public static class StringValidator
    extends TypeValidator {
        public StringValidator(String name, OptionValidator.OptionDescription description) {
            super(name, OptionValue.Kind.STRING, description);
        }
    }

    public static class BooleanValidator
    extends TypeValidator {
        public BooleanValidator(String name, OptionValidator.OptionDescription description) {
            super(name, OptionValue.Kind.BOOLEAN, description);
        }
    }

    public static class MaxRangeDoubleValidator
    extends RangeDoubleValidator {
        private final String minValidatorName;

        public MaxRangeDoubleValidator(String name, double min, double max, String minValidatorName, OptionValidator.OptionDescription description) {
            super(name, min, max, description);
            this.minValidatorName = minValidatorName;
        }

        @Override
        public void validate(OptionValue v, OptionMetaData metaData, OptionSet manager) {
            super.validate(v, metaData, manager);
            OptionValue minValue = manager.getOption(this.minValidatorName);
            if (v.float_val < minValue.float_val) {
                throw UserException.validationError().message(String.format("Option %s must be greater than or equal to Option %s", this.getOptionName(), this.minValidatorName), new Object[0]).build(logger);
            }
        }
    }

    public static class MinRangeDoubleValidator
    extends RangeDoubleValidator {
        private final String maxValidatorName;

        public MinRangeDoubleValidator(String name, double min, double max, String maxValidatorName, OptionValidator.OptionDescription description) {
            super(name, min, max, description);
            this.maxValidatorName = maxValidatorName;
        }

        @Override
        public void validate(OptionValue v, OptionMetaData metaData, OptionSet manager) {
            super.validate(v, metaData, manager);
            OptionValue maxValue = manager.getOption(this.maxValidatorName);
            if (v.float_val > maxValue.float_val) {
                throw UserException.validationError().message(String.format("Option %s must be less than or equal to Option %s", this.getOptionName(), this.maxValidatorName), new Object[0]).build(logger);
            }
        }
    }

    public static class RangeDoubleValidator
    extends DoubleValidator {
        protected final double min;
        protected final double max;

        public RangeDoubleValidator(String name, double min, double max, OptionValidator.OptionDescription description) {
            super(name, description);
            this.min = min;
            this.max = max;
        }

        @Override
        public void validate(OptionValue v, OptionMetaData metaData, OptionSet manager) {
            super.validate(v, metaData, manager);
            if (v.float_val > this.max || v.float_val < this.min) {
                throw UserException.validationError().message(String.format("Option %s must be between %f and %f.", this.getOptionName(), this.min, this.max), new Object[0]).build(logger);
            }
        }
    }

    public static class PowerOfTwoLongValidator
    extends PositiveLongValidator {
        public PowerOfTwoLongValidator(String name, long max, OptionValidator.OptionDescription description) {
            super(name, max, description);
        }

        @Override
        public void validate(OptionValue v, OptionMetaData metaData, OptionSet manager) {
            super.validate(v, metaData, manager);
            if (!PowerOfTwoLongValidator.isPowerOfTwo(v.num_val)) {
                throw UserException.validationError().message(String.format("Option %s must be a power of two.", this.getOptionName()), new Object[0]).build(logger);
            }
        }

        private static boolean isPowerOfTwo(long num) {
            return (num & num - 1L) == 0L;
        }
    }

    public static class PositiveLongValidator
    extends LongValidator {
        protected final long max;

        public PositiveLongValidator(String name, long max, OptionValidator.OptionDescription description) {
            super(name, description);
            this.max = max;
        }

        @Override
        public void validate(OptionValue v, OptionMetaData metaData, OptionSet manager) {
            super.validate(v, metaData, manager);
            if (v.num_val > this.max || v.num_val < 1L) {
                throw UserException.validationError().message(String.format("Option %s must be between %d and %d.", this.getOptionName(), 1, this.max), new Object[0]).build(logger);
            }
        }
    }

    public static class NonNegativeLongValidator
    extends LongValidator {
        private final long max;

        public NonNegativeLongValidator(String name, long max, OptionValidator.OptionDescription description) {
            super(name, description);
            this.max = max;
        }

        @Override
        public void validate(OptionValue v, OptionMetaData metaData, OptionSet manager) {
            super.validate(v, metaData, manager);
            if (v.num_val > this.max || v.num_val < 0L) {
                throw UserException.validationError().message(String.format("Option %s must be between %d and %d.", this.getOptionName(), 0, this.max), new Object[0]).build(logger);
            }
        }
    }
}

