/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest;

import io.netty.util.concurrent.Future;
import java.net.SocketAddress;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.rpc.AbstractDisposableUserClientConnection;
import org.apache.drill.exec.rpc.ConnectionThrottle;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.server.rest.WebSessionResources;

public abstract class BaseWebUserConnection
extends AbstractDisposableUserClientConnection
implements ConnectionThrottle {
    protected WebSessionResources webSessionResources;

    public BaseWebUserConnection(WebSessionResources webSessionResources) {
        this.webSessionResources = webSessionResources;
    }

    @Override
    public UserSession getSession() {
        return this.webSessionResources.getSession();
    }

    @Override
    public Future<Void> getClosureFuture() {
        return this.webSessionResources.getCloseFuture();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.webSessionResources.getRemoteAddress();
    }

    @Override
    public void setAutoRead(boolean enableAutoRead) {
    }

    public WebSessionResources resources() {
        return this.webSessionResources;
    }

    protected String webDataType(TypeProtos.MajorType majorType) {
        StringBuilder dataType = new StringBuilder(majorType.getMinorType().name());
        if (majorType.hasPrecision()) {
            dataType.append("(");
            dataType.append(majorType.getPrecision());
            if (majorType.hasScale()) {
                dataType.append(", ");
                dataType.append(majorType.getScale());
            }
            dataType.append(")");
        } else if (majorType.hasWidth()) {
            dataType.append("(");
            dataType.append(majorType.getWidth());
            dataType.append(")");
        }
        return dataType.toString();
    }
}

