/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.exec.server.rest.DrillRestServer;
import org.apache.drill.exec.server.rest.OAuthRequests;
import org.apache.drill.exec.server.rest.OAuthTokenContainer;
import org.apache.drill.exec.server.rest.PluginConfigWrapper;
import org.apache.drill.exec.server.rest.StorageResources;
import org.apache.drill.exec.server.rest.UsernamePasswordContainer;
import org.apache.drill.exec.server.rest.ViewableWithPermissions;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.glassfish.jersey.server.mvc.Viewable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RolesAllowed(value={"authenticated"})
public class CredentialResources {
    private static final Logger logger = LoggerFactory.getLogger(CredentialResources.class);
    private static final Comparator<PluginConfigWrapper> PLUGIN_COMPARATOR = Comparator.comparing(PluginConfigWrapper::getName);
    private static final String ALL_PLUGINS = "all";
    private static final String ENABLED_PLUGINS = "enabled";
    private static final String DISABLED_PLUGINS = "disabled";
    private static final String TRANSLATES_USERS = "translates_users";
    @Inject
    DrillRestServer.UserAuthEnabled authEnabled;
    @Inject
    StoragePluginRegistry storage;
    @Inject
    SecurityContext sc;
    @Inject
    HttpServletRequest request;

    @GET
    @Path(value="/credentials")
    @Produces(value={"text/html"})
    @Operation(externalDocs=@ExternalDocumentation(description="Apache Drill REST API documentation:", url="https://drill.apache.org/docs/rest-api-introduction/"))
    public Viewable getPlugins() {
        List model = this.getPluginsJSON().stream().map(plugin -> new StorageResources.StoragePluginModel((PluginConfigWrapper)plugin, this.request, this.sc)).collect(Collectors.toList());
        if (model.isEmpty()) {
            model.add(new StorageResources.StoragePluginModel(null, this.request, this.sc));
        }
        return ViewableWithPermissions.create(this.authEnabled.get(), "/rest/credentials/list.ftl", this.sc, model);
    }

    @GET
    @Path(value="/credentials.json")
    @Produces(value={"application/json"})
    public List<PluginConfigWrapper> getPluginsJSON() {
        return this.getConfigsFor(TRANSLATES_USERS);
    }

    @GET
    @Path(value="/credentials{group: (/[^/]+?)*}-plugins.json")
    @Produces(value={"application/json"})
    @Operation(externalDocs=@ExternalDocumentation(description="Apache Drill REST API documentation:", url="https://drill.apache.org/docs/rest-api-introduction/"))
    public List<PluginConfigWrapper> getConfigsFor(@PathParam(value="group") String pluginGroup) {
        StoragePluginRegistry.PluginFilter filter;
        switch (pluginGroup.trim()) {
            case "all": {
                filter = StoragePluginRegistry.PluginFilter.ALL;
                break;
            }
            case "enabled": {
                filter = StoragePluginRegistry.PluginFilter.ENABLED;
                break;
            }
            case "disabled": {
                filter = StoragePluginRegistry.PluginFilter.DISABLED;
                break;
            }
            case "translates_users": {
                filter = StoragePluginRegistry.PluginFilter.TRANSLATES_USERS;
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        List<PluginConfigWrapper> results = StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.storage.storedConfigs(filter).entrySet().iterator(), 16), false).map(entry -> new PluginConfigWrapper((String)entry.getKey(), (StoragePluginConfig)entry.getValue())).sorted(PLUGIN_COMPARATOR).collect(Collectors.toList());
        if (results.isEmpty()) {
            return Collections.emptyList();
        }
        return results;
    }

    @POST
    @Path(value="/credentials/update_credentials")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @Operation(externalDocs=@ExternalDocumentation(description="Apache Drill REST API documentation:", url="https://drill.apache.org/docs/rest-api-introduction/"))
    public Response createOrUpdateCredentials(@FormParam(value="plugin") String pluginName, @FormParam(value="username") String username, @FormParam(value="password") String password) {
        String queryUser = this.sc.getUserPrincipal().getName();
        if ((pluginName = pluginName.trim()).isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.message("A storage config name may not be empty", new Object[0])).build();
        }
        StoragePluginConfig config = this.storage.getStoredConfig(pluginName);
        if (config.getAuthMode() != StoragePluginConfig.AuthMode.USER_TRANSLATION) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.message(pluginName + " does not support per user translation.", new Object[0])).build();
        }
        CredentialsProvider credentialProvider = config.getCredentialsProvider();
        credentialProvider.setUserCredentials(username, password, queryUser);
        StoragePluginConfig newConfig = config.updateCredentialProvider(credentialProvider);
        newConfig.setEnabled(config.isEnabled());
        try {
            this.storage.validatedPut(pluginName, newConfig);
            this.storage.setEnabled(pluginName, newConfig.isEnabled());
        }
        catch (StoragePluginRegistry.PluginException e) {
            logger.error("Error while saving plugin", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.message("Error while saving plugin: %s", e.getMessage())).build();
        }
        return Response.ok().entity((Object)this.message("Success", new Object[0])).build();
    }

    @POST
    @Path(value="/credentials/{pluginName}/update_credentials.json")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(externalDocs=@ExternalDocumentation(description="Apache Drill REST API documentation:", url="https://drill.apache.org/docs/rest-api-introduction/"))
    public Response createOrUpdatePlugin(@PathParam(value="pluginName") String pluginName, UsernamePasswordContainer credentials) {
        String queryUser = this.sc.getUserPrincipal().getName();
        if (pluginName.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.message("A storage config name may not be empty", new Object[0])).build();
        }
        String cleanPluginName = pluginName.trim();
        StoragePluginConfig config = this.storage.getStoredConfig(cleanPluginName);
        if (config.getAuthMode() != StoragePluginConfig.AuthMode.USER_TRANSLATION) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.message(cleanPluginName + " does not have user translation enabled.", new Object[0])).build();
        }
        CredentialsProvider credentialProvider = config.getCredentialsProvider();
        credentialProvider.setUserCredentials(credentials.getUsername(), credentials.getPassword(), queryUser);
        StoragePluginConfig newConfig = config.updateCredentialProvider(credentialProvider);
        newConfig.setEnabled(config.isEnabled());
        try {
            this.storage.validatedPut(cleanPluginName, newConfig);
            this.storage.setEnabled(cleanPluginName, newConfig.isEnabled());
        }
        catch (StoragePluginRegistry.PluginException e) {
            logger.error("Error while saving plugin", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.message("Error while updating plugin credentials: %s", e.getMessage())).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"Credentials have been updated.").build();
    }

    @POST
    @Path(value="/credentials/{name}/update_refresh_token")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(externalDocs=@ExternalDocumentation(description="Apache Drill REST API documentation:", url="https://drill.apache.org/docs/rest-api-introduction/"))
    public Response updateRefreshToken(@PathParam(value="name") String name, OAuthTokenContainer tokens) {
        return OAuthRequests.updateRefreshToken(name, tokens, this.storage, this.authEnabled, this.sc);
    }

    @POST
    @Path(value="/credentials/{name}/update_access_token")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(externalDocs=@ExternalDocumentation(description="Apache Drill REST API documentation:", url="https://drill.apache.org/docs/rest-api-introduction/"))
    public Response updateAccessToken(@PathParam(value="name") String name, OAuthTokenContainer tokens) {
        return OAuthRequests.updateAccessToken(name, tokens, this.storage, this.authEnabled, this.sc);
    }

    @POST
    @Path(value="/credentials/{name}/update_oauth_tokens")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(externalDocs=@ExternalDocumentation(description="Apache Drill REST API documentation:", url="https://drill.apache.org/docs/rest-api-introduction/"))
    public Response updateOAuthTokens(@PathParam(value="name") String name, OAuthTokenContainer tokenContainer) {
        return OAuthRequests.updateOAuthTokens(name, tokenContainer, this.storage, this.authEnabled, this.sc);
    }

    @GET
    @Path(value="/credentials/{name}/update_oauth2_authtoken")
    @Produces(value={"text/html"})
    @Operation(externalDocs=@ExternalDocumentation(description="Apache Drill REST API documentation:", url="https://drill.apache.org/docs/rest-api-introduction/"))
    public Response updateAuthToken(@PathParam(value="name") String name, @QueryParam(value="code") String code) {
        return OAuthRequests.updateAuthToken(name, code, this.request, this.storage, this.authEnabled, this.sc);
    }

    private JsonResult message(String message, Object ... args) {
        return new JsonResult(String.format(message, args));
    }

    @XmlRootElement
    public static class JsonResult {
        private final String result;

        public JsonResult(String result) {
            this.result = result;
        }

        public String getResult() {
            return this.result;
        }
    }
}

