/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.base.JsonMappingExceptionMapper;
import com.fasterxml.jackson.jaxrs.base.JsonParseExceptionMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.cache.WebappTemplateLoader;
import freemarker.core.HTMLOutputFormat;
import freemarker.core.OutputFormat;
import freemarker.template.Configuration;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.swagger.v3.jaxrs2.integration.resources.OpenApiResource;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.info.License;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Principal;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.RuntimeType;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.rest.CredentialResources;
import org.apache.drill.exec.server.rest.DrillRoot;
import org.apache.drill.exec.server.rest.GenericExceptionMapper;
import org.apache.drill.exec.server.rest.LogInLogOutResources;
import org.apache.drill.exec.server.rest.LogsResources;
import org.apache.drill.exec.server.rest.MetricsResources;
import org.apache.drill.exec.server.rest.QueryResources;
import org.apache.drill.exec.server.rest.StatusResources;
import org.apache.drill.exec.server.rest.StorageResources;
import org.apache.drill.exec.server.rest.ThreadsResources;
import org.apache.drill.exec.server.rest.WebServer;
import org.apache.drill.exec.server.rest.WebSessionResources;
import org.apache.drill.exec.server.rest.WebUserConnection;
import org.apache.drill.exec.server.rest.auth.AuthDynamicFeature;
import org.apache.drill.exec.server.rest.auth.DrillUserPrincipal;
import org.apache.drill.exec.server.rest.profile.ProfileResources;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.sys.PersistentStoreProvider;
import org.apache.drill.exec.work.WorkManager;
import org.apache.drill.shaded.guava.com.google.common.base.Strings;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.RolesAllowedDynamicFeature;
import org.glassfish.jersey.server.mvc.freemarker.FreemarkerMvcFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OpenAPIDefinition(info=@Info(title="Apache Drill REST API", description="OpenAPI Specification", license=@License(name="Apache Software Foundation (ASF)", url="http://www.apache.org/licenses/LICENSE-2.0"), contact=@Contact(name="Apache Drill", url="https://drill.apache.org/")))
public class DrillRestServer
extends ResourceConfig {
    static final Logger logger = LoggerFactory.getLogger(DrillRestServer.class);

    public DrillRestServer(final WorkManager workManager, ServletContext servletContext, final Drillbit drillbit) {
        this.register(DrillRoot.class);
        this.register(StatusResources.class);
        this.register(StorageResources.class);
        this.register(ProfileResources.class);
        this.register(CredentialResources.class);
        this.register(QueryResources.class);
        this.register(MetricsResources.class);
        this.register(ThreadsResources.class);
        this.register(LogsResources.class);
        this.property("jersey.config.server.mvc.factory.freemarker", this.getFreemarkerConfiguration(servletContext));
        this.register(FreemarkerMvcFeature.class);
        this.register(MultiPartFeature.class);
        this.property("jersey.config.server.disableMetainfServicesLookup", true);
        final boolean isAuthEnabled = workManager.getContext().getConfig().getBoolean("drill.exec.security.user.auth.enabled");
        if (isAuthEnabled) {
            this.register(LogInLogOutResources.class);
            this.register(AuthDynamicFeature.class);
            this.register(RolesAllowedDynamicFeature.class);
        }
        String disableMoxy = PropertiesHelper.getPropertyNameForRuntime((String)"jersey.config.disableMoxyJson", (RuntimeType)this.getConfiguration().getRuntimeType());
        this.property(disableMoxy, true);
        this.register(JsonParseExceptionMapper.class);
        this.register(JsonMappingExceptionMapper.class);
        this.register(GenericExceptionMapper.class);
        JacksonJaxbJsonProvider provider = new JacksonJaxbJsonProvider();
        provider.setMapper(workManager.getContext().getLpPersistence().getMapper());
        this.register(provider);
        final EventLoop executor = workManager.getContext().getBitLoopGroup().next();
        this.register(new AbstractBinder(){

            protected void configure() {
                DrillbitContext context = workManager.getContext();
                this.bind(drillbit).to(Drillbit.class);
                this.bind(workManager).to(WorkManager.class);
                this.bind(executor).to(EventExecutor.class);
                this.bind(context.getLpPersistence().getMapper()).to(ObjectMapper.class);
                this.bind(context.getStoreProvider()).to(PersistentStoreProvider.class);
                this.bind(context.getStorage()).to(StoragePluginRegistry.class);
                this.bind(new UserAuthEnabled(isAuthEnabled)).to(UserAuthEnabled.class);
                if (isAuthEnabled) {
                    this.bindFactory(DrillUserPrincipalProvider.class).to(DrillUserPrincipal.class);
                    this.bindFactory(AuthWebUserConnectionProvider.class).to(WebUserConnection.class);
                } else {
                    this.bindFactory(AnonDrillUserPrincipalProvider.class).to(DrillUserPrincipal.class);
                    this.bindFactory(AnonWebUserConnectionProvider.class).to(WebUserConnection.class);
                }
            }
        });
        this.register(OpenApiResource.class);
    }

    private Configuration getFreemarkerConfiguration(ServletContext servletContext) {
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_26);
        configuration.setOutputFormat((OutputFormat)HTMLOutputFormat.INSTANCE);
        ArrayList<Object> loaders = new ArrayList<Object>();
        loaders.add(new WebappTemplateLoader(servletContext));
        loaders.add(new ClassTemplateLoader(DrillRestServer.class, "/"));
        try {
            loaders.add(new FileTemplateLoader(new File("/")));
        }
        catch (IOException e) {
            logger.error("Could not set up file template loader.", (Throwable)e);
        }
        configuration.setTemplateLoader((TemplateLoader)new MultiTemplateLoader(loaders.toArray(new TemplateLoader[loaders.size()])));
        return configuration;
    }

    public static class UserAuthEnabled {
        private final boolean value;

        public UserAuthEnabled(boolean value) {
            this.value = value;
        }

        public boolean get() {
            return this.value;
        }
    }

    public static class AnonDrillUserPrincipalProvider
    implements Factory<DrillUserPrincipal> {
        @RequestScoped
        public DrillUserPrincipal provide() {
            return new DrillUserPrincipal.AnonDrillUserPrincipal();
        }

        public void dispose(DrillUserPrincipal principal) {
        }
    }

    public static class DrillUserPrincipalProvider
    implements Factory<DrillUserPrincipal> {
        @Inject
        HttpServletRequest request;

        public DrillUserPrincipal provide() {
            return (DrillUserPrincipal)this.request.getUserPrincipal();
        }

        public void dispose(DrillUserPrincipal principal) {
        }
    }

    public static class AnonWebUserConnectionProvider
    implements Factory<WebUserConnection> {
        @Inject
        HttpServletRequest request;
        @Inject
        WorkManager workManager;
        @Inject
        EventExecutor executor;

        public WebUserConnection provide() {
            DrillbitContext drillbitContext = this.workManager.getContext();
            DrillConfig config = drillbitContext.getConfig();
            BufferAllocator sessionAllocator = drillbitContext.getAllocator().newChildAllocator("WebServer:AnonUserSession", config.getLong("drill.exec.http.session.memory.reservation"), config.getLong("drill.exec.http.session.memory.maximum"));
            Principal sessionUserPrincipal = this.createSessionUserPrincipal(config, this.request);
            UserSession drillUserSession = UserSession.Builder.newBuilder().withCredentials(UserBitShared.UserCredentials.newBuilder().setUserName(sessionUserPrincipal.getName()).build()).withOptionManager(drillbitContext.getOptionManager()).setSupportComplexTypes(drillbitContext.getConfig().getBoolean("drill.client.supports-complex-types")).build();
            InetSocketAddress remoteAddress = null;
            try {
                remoteAddress = new InetSocketAddress(InetAddress.getByName(this.request.getRemoteAddr()), this.request.getRemotePort());
            }
            catch (Exception ex) {
                logger.trace("Failed to get the remote address of the http session request", (Throwable)ex);
            }
            DefaultPromise<Void> closeFuture = new DefaultPromise<Void>(this.executor);
            WebSessionResources webSessionResources = new WebSessionResources(sessionAllocator, remoteAddress, drillUserSession, closeFuture);
            return new WebUserConnection.AnonWebUserConnection(webSessionResources);
        }

        public void dispose(WebUserConnection instance) {
        }

        @Deprecated
        private Principal createSessionUserPrincipal(DrillConfig config, HttpServletRequest request) {
            String userName;
            if (WebServer.isOnlyImpersonationEnabled(config) && !Strings.isNullOrEmpty(userName = request.getHeader("User-Name"))) {
                return new DrillUserPrincipal(userName, true);
            }
            return new DrillUserPrincipal.AnonDrillUserPrincipal();
        }
    }

    public static class AuthWebUserConnectionProvider
    implements Factory<WebUserConnection> {
        @Inject
        HttpServletRequest request;
        @Inject
        WorkManager workManager;
        @Inject
        EventExecutor executor;

        public WebUserConnection provide() {
            HttpSession session = this.request.getSession();
            Principal sessionUserPrincipal = this.request.getUserPrincipal();
            if (sessionUserPrincipal == null) {
                return null;
            }
            WebSessionResources webSessionResources = (WebSessionResources)session.getAttribute(WebSessionResources.class.getSimpleName());
            if (webSessionResources == null) {
                DrillbitContext drillbitContext = this.workManager.getContext();
                DrillConfig config = drillbitContext.getConfig();
                UserSession drillUserSession = UserSession.Builder.newBuilder().withCredentials(UserBitShared.UserCredentials.newBuilder().setUserName(sessionUserPrincipal.getName()).build()).withOptionManager(drillbitContext.getOptionManager()).setSupportComplexTypes(config.getBoolean("drill.client.supports-complex-types")).build();
                InetSocketAddress remoteAddress = null;
                try {
                    remoteAddress = new InetSocketAddress(InetAddress.getByName(this.request.getRemoteAddr()), this.request.getRemotePort());
                    session.setAttribute(SocketAddress.class.getSimpleName(), (Object)remoteAddress);
                }
                catch (Exception ex) {
                    logger.trace("Failed to get the remote address of the http session request", (Throwable)ex);
                }
                String sessionAllocatorName = String.format("WebServer:AuthUserSession:%s", session.getId());
                BufferAllocator sessionAllocator = this.workManager.getContext().getAllocator().newChildAllocator(sessionAllocatorName, config.getLong("drill.exec.http.session.memory.reservation"), config.getLong("drill.exec.http.session.memory.maximum"));
                DefaultPromise<Void> closeFuture = new DefaultPromise<Void>(this.executor);
                webSessionResources = new WebSessionResources(sessionAllocator, remoteAddress, drillUserSession, closeFuture);
                session.setAttribute(WebSessionResources.class.getSimpleName(), (Object)webSessionResources);
            }
            return new WebUserConnection(webSessionResources);
        }

        public void dispose(WebUserConnection instance) {
        }
    }
}

