/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest;

import java.net.URI;
import java.net.URLDecoder;
import java.util.Set;
import javax.annotation.security.PermitAll;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.server.rest.ViewableWithPermissions;
import org.apache.drill.exec.server.rest.auth.AuthDynamicFeature;
import org.apache.drill.exec.server.rest.auth.DrillHttpSecurityHandlerProvider;
import org.apache.drill.exec.work.WorkManager;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.eclipse.jetty.security.authentication.SessionAuthentication;
import org.glassfish.jersey.server.mvc.Viewable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@PermitAll
public class LogInLogOutResources {
    private static final Logger logger = LoggerFactory.getLogger(LogInLogOutResources.class);
    @Inject
    WorkManager workManager;

    private void updateSessionRedirectInfo(String redirect, HttpServletRequest request) throws Exception {
        if (!StringUtils.isEmpty((CharSequence)redirect)) {
            HttpSession session = request.getSession(true);
            URI destURI = UriBuilder.fromUri((String)URLDecoder.decode(redirect, "UTF-8")).build(new Object[0]);
            session.setAttribute("org.eclipse.jetty.security.form_URI", (Object)destURI.getPath());
        }
    }

    @GET
    @Path(value="/login")
    @Produces(value={"text/html"})
    public Viewable getLoginPage(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context SecurityContext sc, @Context UriInfo uriInfo, @QueryParam(value="redirect") String redirect) throws Exception {
        if (AuthDynamicFeature.isUserLoggedIn(sc)) {
            request.getRequestDispatcher("/").forward((ServletRequest)request, (ServletResponse)response);
            return null;
        }
        this.updateSessionRedirectInfo(redirect, request);
        return ViewableWithPermissions.createLoginPage(null);
    }

    @GET
    @Path(value="/spnegoLogin")
    @Produces(value={"text/html"})
    public Viewable getSpnegoLogin(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context SecurityContext sc, @Context UriInfo uriInfo, @QueryParam(value="redirect") String redirect) throws Exception {
        if (AuthDynamicFeature.isUserLoggedIn(sc)) {
            request.getRequestDispatcher("/").forward((ServletRequest)request, (ServletResponse)response);
            return null;
        }
        String errorString = "Invalid SPNEGO credentials or SPNEGO is not configured";
        MainLoginPageModel model = new MainLoginPageModel("Invalid SPNEGO credentials or SPNEGO is not configured");
        return ViewableWithPermissions.createMainLoginPage(model);
    }

    @POST
    @Path(value="/login")
    @Produces(value={"text/html"})
    public Viewable getLoginPageAfterValidationError() {
        return ViewableWithPermissions.createLoginPage("Invalid username/password credentials.");
    }

    @GET
    @Path(value="/logout")
    public void logout(@Context HttpServletRequest req, @Context HttpServletResponse resp) throws Exception {
        HttpSession session = req.getSession();
        if (session != null) {
            Object authCreds = session.getAttribute("org.eclipse.jetty.security.UserIdentity");
            if (authCreds != null) {
                SessionAuthentication sessionAuth = (SessionAuthentication)authCreds;
                logger.info("WebUser {} logged out from {}:{}", new Object[]{sessionAuth.getUserIdentity().getUserPrincipal().getName(), req.getRemoteHost(), req.getRemotePort()});
            }
            session.invalidate();
        }
        req.getRequestDispatcher("/").forward((ServletRequest)req, (ServletResponse)resp);
    }

    @GET
    @Path(value="/mainLogin")
    @Produces(value={"text/html"})
    public Viewable getMainLoginPage(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context SecurityContext sc, @Context UriInfo uriInfo, @QueryParam(value="redirect") String redirect) throws Exception {
        this.updateSessionRedirectInfo(redirect, request);
        MainLoginPageModel model = new MainLoginPageModel(null);
        return ViewableWithPermissions.createMainLoginPage(model);
    }

    @VisibleForTesting
    public class MainLoginPageModel {
        private final String error;
        private final boolean authEnabled;
        private final Set<String> configuredMechs;

        MainLoginPageModel(String error) {
            this.error = error;
            DrillConfig config = LogInLogOutResources.this.workManager.getContext().getConfig();
            this.authEnabled = config.getBoolean("drill.exec.security.user.auth.enabled");
            this.configuredMechs = DrillHttpSecurityHandlerProvider.getHttpAuthMechanisms(config);
        }

        public boolean isSpnegoEnabled() {
            return this.authEnabled && this.configuredMechs.contains("SPNEGO");
        }

        public boolean isFormEnabled() {
            return this.authEnabled && this.configuredMechs.contains("FORM");
        }

        public String getError() {
            return this.error;
        }
    }
}

