/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.server.rest.DrillRestServer;
import org.apache.drill.exec.server.rest.ViewableWithPermissions;
import org.apache.drill.exec.work.WorkManager;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;
import org.glassfish.jersey.server.mvc.Viewable;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RolesAllowed(value={"admin"})
public class LogsResources {
    private static final Logger logger = LoggerFactory.getLogger(LogsResources.class);
    @Inject
    DrillRestServer.UserAuthEnabled authEnabled;
    @Inject
    SecurityContext sc;
    @Inject
    WorkManager work;
    private static final FileFilter file_filter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isFile();
        }
    };
    private static final DateTimeFormatter format = DateTimeFormat.forPattern((String)"MM/dd/yyyy HH:mm:ss");

    @GET
    @Path(value="/logs")
    @Produces(value={"text/html"})
    public Viewable getLogs() {
        Set<Log> logs = this.getLogsJSON();
        return ViewableWithPermissions.create(this.authEnabled.get(), "/rest/logs/list.ftl", this.sc, logs);
    }

    @GET
    @Path(value="/logs.json")
    @Produces(value={"application/json"})
    public Set<Log> getLogsJSON() {
        File[] files;
        TreeSet<Log> logs = Sets.newTreeSet();
        for (File file : files = this.getLogFolder().listFiles(file_filter)) {
            logs.add(new Log(file.getName(), file.length(), file.lastModified()));
        }
        return logs;
    }

    @GET
    @Path(value="/log/{name}/content")
    @Produces(value={"text/html"})
    public Viewable getLog(@PathParam(value="name") String name) throws IOException {
        try {
            LogContent content = this.getLogJSON(name);
            return ViewableWithPermissions.create(this.authEnabled.get(), "/rest/logs/log.ftl", this.sc, content);
        }
        catch (Error | Exception e) {
            logger.error("Exception was thrown when fetching log {} :\n{}", (Object)name, (Object)e);
            return ViewableWithPermissions.create(this.authEnabled.get(), "/rest/errorMessage.ftl", this.sc, e);
        }
    }

    @GET
    @Path(value="/log/{name}/content.json")
    @Produces(value={"application/json"})
    public LogContent getLogJSON(@PathParam(value="name") String name) throws IOException {
        File file = this.getFileByName(this.getLogFolder(), name);
        final int maxLines = this.work.getContext().getOptionManager().getOption((String)"web.logs.max_lines").num_val.intValue();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            LinkedHashMap<Integer, String> cache = new LinkedHashMap<Integer, String>(maxLines, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<Integer, String> eldest) {
                    return this.size() > maxLines;
                }
            };
            int i = 0;
            while ((line = br.readLine()) != null) {
                cache.put(i++, line);
            }
            LogContent logContent = new LogContent(file.getName(), cache.values(), maxLines);
            return logContent;
        }
    }

    @GET
    @Path(value="/log/{name}/download")
    @Produces(value={"text/plain"})
    public Response getFullLog(@PathParam(value="name") String name) {
        File file = this.getFileByName(this.getLogFolder(), name);
        return Response.ok((Object)file).header("Content-Disposition", (Object)String.format("attachment;filename=\"%s\"", name)).build();
    }

    private File getLogFolder() {
        return new File(Preconditions.checkNotNull(System.getenv("DRILL_LOG_DIR"), "DRILL_LOG_DIR variable is not set"));
    }

    private File getFileByName(File folder, String name) {
        File[] files = folder.listFiles((dir, fileName) -> fileName.equals(name));
        if (files.length == 0) {
            throw new DrillRuntimeException(name + " doesn't exist");
        }
        return files[0];
    }

    @XmlRootElement
    public class Log
    implements Comparable<Log> {
        private final String name;
        private final long size;
        private final DateTime lastModified;

        @JsonCreator
        public Log(@JsonProperty(value="size") String name, @JsonProperty(value="lastModified") long size, long lastModified) {
            this.name = name;
            this.size = size;
            this.lastModified = new DateTime(lastModified);
        }

        public String getName() {
            return this.name;
        }

        public String getSize() {
            return Math.ceil((double)this.size / 1024.0) + " KB";
        }

        public String getLastModified() {
            return this.lastModified.toString(format);
        }

        @Override
        public int compareTo(Log log) {
            return this.getName().compareTo(log.getName());
        }
    }

    @XmlRootElement
    public class LogContent {
        private final String name;
        private final Collection<String> lines;
        private final int maxLines;

        @JsonCreator
        public LogContent(@JsonProperty(value="lines") String name, @JsonProperty(value="maxLines") Collection<String> lines, int maxLines) {
            this.name = name;
            this.lines = lines;
            this.maxLines = maxLines;
        }

        public String getName() {
            return this.name;
        }

        public Collection<String> getLines() {
            return this.lines;
        }

        public int getMaxLines() {
            return this.maxLines;
        }
    }
}

