/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.OAuthConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.security.UsernamePasswordCredentials;
import org.apache.drill.exec.store.security.oauth.OAuthTokenCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
public class PluginConfigWrapper {
    private static final Logger logger = LoggerFactory.getLogger(PluginConfigWrapper.class);
    private final String name;
    private final StoragePluginConfig config;

    @JsonCreator
    public PluginConfigWrapper(@JsonProperty(value="name") String name, @JsonProperty(value="config") StoragePluginConfig config) {
        this.name = name;
        this.config = config;
    }

    public String getName() {
        return this.name;
    }

    public StoragePluginConfig getConfig() {
        return this.config;
    }

    public boolean enabled() {
        return this.config.isEnabled();
    }

    @JsonIgnore
    public String getUserName(String queryUser) {
        CredentialsProvider credentialsProvider = this.config.getCredentialsProvider();
        Optional<UsernamePasswordCredentials> credentials = new UsernamePasswordCredentials.Builder().setCredentialsProvider(credentialsProvider).setQueryUser(queryUser).build();
        return credentials.map(UsernamePasswordCredentials::getUsername).orElse(null);
    }

    @JsonIgnore
    public String getPassword(String queryUser) {
        CredentialsProvider credentialsProvider = this.config.getCredentialsProvider();
        Optional<UsernamePasswordCredentials> credentials = new UsernamePasswordCredentials.Builder().setCredentialsProvider(credentialsProvider).setQueryUser(queryUser).build();
        return credentials.map(UsernamePasswordCredentials::getPassword).orElse(null);
    }

    public void createOrUpdateInStorage(StoragePluginRegistry storage) throws StoragePluginRegistry.PluginException {
        storage.validatedPut(this.name, this.config);
    }

    @JsonIgnore
    public boolean isOauth() {
        CredentialsProvider credentialsProvider = this.config.getCredentialsProvider();
        if (credentialsProvider == null) {
            return false;
        }
        Optional<OAuthTokenCredentials> tokenCredentials = new OAuthTokenCredentials.Builder().setCredentialsProvider(credentialsProvider).build();
        return tokenCredentials.map(OAuthTokenCredentials::getClientID).orElse(null) != null;
    }

    @JsonIgnore
    public String getClientID() {
        CredentialsProvider credentialsProvider = this.config.getCredentialsProvider();
        return credentialsProvider.getCredentials().getOrDefault("clientID", "");
    }

    @JsonIgnore
    public String getAuthorizationURIWithParams() {
        Map<String, String> params;
        if (!this.isOauth()) {
            logger.warn("{} is not an OAuth enabled storage plugin", (Object)this.name);
            return "";
        }
        String clientID = this.getClientID();
        OAuthConfig oAuthConfig = this.config.oAuthConfig();
        String authorizationURI = oAuthConfig.getAuthorizationURL();
        StringBuilder finalUrlBuilder = new StringBuilder();
        finalUrlBuilder.append(authorizationURI).append("?client_id=").append(clientID).append("&redirect_uri=").append(oAuthConfig.getCallbackURL());
        if (StringUtils.isNotEmpty((CharSequence)oAuthConfig.getScope())) {
            finalUrlBuilder.append("&scope=").append(this.URLEncodeValue(oAuthConfig.getScope()));
        }
        if ((params = oAuthConfig.getAuthorizationParams()) != null) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                finalUrlBuilder.append("&").append(param.getKey()).append("=").append(this.URLEncodeValue(param.getValue()));
            }
        }
        return finalUrlBuilder.toString();
    }

    private String URLEncodeValue(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw UserException.internalError(e).message("Error encoding value: " + value, new Object[0]).build(logger);
        }
    }
}

