/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.exceptions.UserRemoteException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.exec.server.rest.BaseQueryRunner;
import org.apache.drill.exec.server.rest.QueryWrapper;
import org.apache.drill.exec.server.rest.WebUserConnection;
import org.apache.drill.exec.work.WorkManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestQueryRunner
extends BaseQueryRunner {
    private static final Logger logger = LoggerFactory.getLogger(QueryWrapper.class);
    private static final MemoryMXBean memMXBean = ManagementFactory.getMemoryMXBean();
    private final QueryWrapper query;

    public RestQueryRunner(QueryWrapper query, WorkManager workManager, WebUserConnection webUserConnection) {
        super(workManager, webUserConnection);
        this.query = query;
    }

    public QueryResult run() throws Exception {
        this.applyUserName(this.query.getUserName());
        this.applyOptions(this.query.getOptions());
        this.applyDefaultSchema(this.query.getDefaultSchema());
        this.applyRowLimit(this.query.getAutoLimitRowCount());
        return this.submitQuery();
    }

    private QueryResult submitQuery() {
        this.webUserConnection.setAutoLimitRowCount(this.maxRows);
        this.startQuery(UserBitShared.QueryType.valueOf(this.query.getQueryType()), this.query.getQuery(), this.webUserConnection);
        double memoryFailureThreshold = this.workManager.getContext().getConfig().getDouble("drill.exec.http.memory.heap.failure.threshold");
        boolean isComplete = false;
        boolean nearlyOutOfHeapSpace = false;
        float usagePercent = this.getHeapUsage();
        logger.debug("Wait until the query execution is complete or there is error submitting the query");
        do {
            try {
                isComplete = this.webUserConnection.await(TimeUnit.SECONDS.toMillis(1L));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            usagePercent = this.getHeapUsage();
            if (!(memoryFailureThreshold > 0.0) || !((double)usagePercent > memoryFailureThreshold)) continue;
            nearlyOutOfHeapSpace = true;
        } while (!isComplete && !nearlyOutOfHeapSpace);
        if (nearlyOutOfHeapSpace) {
            UserException almostOutOfHeapException = UserException.resourceError().message("There is not enough heap memory to run this query using the web interface. ", new Object[0]).addContext("Please try a query with fewer columns or with a filter or limit condition to limit the data returned. ").addContext("You can also try an ODBC/JDBC client. ").build(logger);
            this.workManager.getBee().getForemanForQueryId(this.queryId).addToEventQueue(UserBitShared.QueryResult.QueryState.FAILED, almostOutOfHeapException);
            throw almostOutOfHeapException;
        }
        logger.trace("Query {} is completed ", (Object)this.queryId);
        if (this.webUserConnection.getError() != null) {
            throw new UserRemoteException(this.webUserConnection.getError());
        }
        return new QueryResult(this.queryId, this.webUserConnection, this.webUserConnection.results);
    }

    private float getHeapUsage() {
        return (float)memMXBean.getHeapMemoryUsage().getUsed() / (float)memMXBean.getHeapMemoryUsage().getMax();
    }

    public static class QueryResult {
        private final String queryId;
        public final Collection<String> columns;
        public final List<Map<String, String>> rows;
        public final List<String> metadata;
        public final String queryState;
        public final int attemptedAutoLimit;

        public QueryResult(UserBitShared.QueryId queryId, WebUserConnection webUserConnection, List<Map<String, String>> rows) {
            this.queryId = QueryIdHelper.getQueryId(queryId);
            this.columns = webUserConnection.columns;
            this.metadata = webUserConnection.metadata;
            this.queryState = webUserConnection.getQueryState();
            this.rows = rows;
            this.attemptedAutoLimit = webUserConnection.getAutoLimitRowCount();
        }

        public String getQueryId() {
            return this.queryId;
        }
    }
}

