/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.oauth.TokenRegistry;
import org.apache.drill.exec.server.rest.DrillRestServer;
import org.apache.drill.exec.server.rest.OAuthRequests;
import org.apache.drill.exec.server.rest.OAuthTokenContainer;
import org.apache.drill.exec.server.rest.PluginConfigWrapper;
import org.apache.drill.exec.server.rest.ViewableWithPermissions;
import org.apache.drill.exec.server.rest.WebUtils;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.work.WorkManager;
import org.glassfish.jersey.server.mvc.Viewable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RolesAllowed(value={"admin"})
public class StorageResources {
    private static final Logger logger = LoggerFactory.getLogger(StorageResources.class);
    @Inject
    DrillRestServer.UserAuthEnabled authEnabled;
    @Inject
    StoragePluginRegistry storage;
    @Inject
    WorkManager workManager;
    @Inject
    SecurityContext sc;
    @Inject
    HttpServletRequest request;
    private static final String JSON_FORMAT = "json";
    private static final String HOCON_FORMAT = "conf";
    private static final String ALL_PLUGINS = "all";
    private static final String ENABLED_PLUGINS = "enabled";
    private static final String DISABLED_PLUGINS = "disabled";
    private static final Comparator<PluginConfigWrapper> PLUGIN_COMPARATOR = Comparator.comparing(PluginConfigWrapper::getName);

    @GET
    @Path(value="/storage/{group}/plugins/export{format: (/[^/]+?)*}")
    @Produces(value={"application/json"})
    public Response getConfigsFor(@PathParam(value="group") String pluginGroup, @PathParam(value="format") String format) {
        format = StringUtils.isNotEmpty((CharSequence)format) ? format.replace("/", "") : JSON_FORMAT;
        return this.isSupported(format) ? Response.ok().entity((Object)this.getConfigsFor(pluginGroup).toArray()).header("Content-Disposition", (Object)String.format("attachment;filename=\"%s_storage_plugins.%s\"", pluginGroup, format)).build() : Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)this.message("Unknown \"%s\" file format for Storage Plugin config", format)).build();
    }

    @GET
    @Path(value="/storage.json")
    @Produces(value={"application/json"})
    @Operation(externalDocs=@ExternalDocumentation(description="Apache Drill REST API documentation:", url="https://drill.apache.org/docs/rest-api-introduction/"))
    public List<PluginConfigWrapper> getPluginsJSON() {
        return this.getConfigsFor(ALL_PLUGINS);
    }

    @GET
    @Path(value="/storage")
    @Produces(value={"text/html"})
    public Viewable getPlugins() {
        List model = this.getPluginsJSON().stream().map(plugin -> new StoragePluginModel((PluginConfigWrapper)plugin, this.request, this.sc)).collect(Collectors.toList());
        if (model.isEmpty()) {
            model.add(new StoragePluginModel(null, this.request, this.sc));
        }
        return ViewableWithPermissions.create(this.authEnabled.get(), "/rest/storage/list.ftl", this.sc, model);
    }

    @GET
    @Path(value="/storage/{name}.json")
    @Produces(value={"application/json"})
    @Operation(externalDocs=@ExternalDocumentation(description="Apache Drill REST API documentation:", url="https://drill.apache.org/docs/rest-api-introduction/"))
    public Response getPluginConfig(@PathParam(value="name") String name) {
        try {
            return Response.ok((Object)new PluginConfigWrapper(name, this.storage.getStoredConfig(name))).build();
        }
        catch (Exception e) {
            logger.error("Failure while trying to access storage config: {}", (Object)name, (Object)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.message("Failure while trying to access storage config: %s", e.getMessage())).build();
        }
    }

    @GET
    @Path(value="/storage/{name}")
    @Produces(value={"text/html"})
    public Viewable getPlugin(@PathParam(value="name") String name) {
        StoragePluginModel model = new StoragePluginModel((PluginConfigWrapper)this.getPluginConfig(name).getEntity(), this.request, this.sc);
        return ViewableWithPermissions.create(this.authEnabled.get(), "/rest/storage/update.ftl", this.sc, model);
    }

    @POST
    @Path(value="/storage/{name}/enable/{val}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(externalDocs=@ExternalDocumentation(description="Apache Drill REST API documentation:", url="https://drill.apache.org/docs/rest-api-introduction/"))
    public Response enablePlugin(@PathParam(value="name") String name, @PathParam(value="val") Boolean enable) {
        try {
            this.storage.setEnabled(name, enable);
            return Response.ok().entity((Object)this.message("Success", new Object[0])).build();
        }
        catch (StoragePluginRegistry.PluginNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.message("No plugin exists with the given name: " + name, new Object[0])).build();
        }
        catch (StoragePluginRegistry.PluginException e) {
            logger.info("Error when enabling storage name: {} flag: {}", (Object)name, (Object)enable);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.message("Unable to enable/disable plugin: %s", e.getMessage())).build();
        }
    }

    @POST
    @Path(value="/storage/{name}/update_refresh_token")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Deprecated
    public Response updateRefreshToken(@PathParam(value="name") String name, OAuthTokenContainer tokens) {
        logger.warn("Deprecated endpoint call: {}", (Object)("/storage/" + name + "/update_refresh_token."));
        return OAuthRequests.updateRefreshToken(name, tokens, this.storage, this.authEnabled, this.sc);
    }

    @POST
    @Path(value="/storage/{name}/update_access_token")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Deprecated
    public Response updateAccessToken(@PathParam(value="name") String name, OAuthTokenContainer tokens) {
        logger.warn("Deprecated endpoint call: {}", (Object)("/storage/" + name + "/update_access_token."));
        return OAuthRequests.updateAccessToken(name, tokens, this.storage, this.authEnabled, this.sc);
    }

    @POST
    @Path(value="/storage/{name}/update_oauth_tokens")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Deprecated
    public Response updateOAuthTokens(@PathParam(value="name") String name, OAuthTokenContainer tokenContainer) {
        logger.warn("Deprecated endpoint call: {}", (Object)("/storage/" + name + "/update_oauth_tokens."));
        return OAuthRequests.updateOAuthTokens(name, tokenContainer, this.storage, this.authEnabled, this.sc);
    }

    @GET
    @Path(value="/storage/{name}/update_oauth2_authtoken")
    @Produces(value={"text/html"})
    @Deprecated
    public Response updateAuthToken(@PathParam(value="name") String name, @QueryParam(value="code") String code) {
        logger.warn("Deprecated endpoint call: {}", (Object)("/storage/" + name + "/update_oauth2_authtoken."));
        return OAuthRequests.updateAuthToken(name, code, this.request, this.storage, this.authEnabled, this.sc);
    }

    @GET
    @Path(value="/storage/{name}/enable/{val}")
    @Produces(value={"application/json"})
    @Operation(externalDocs=@ExternalDocumentation(description="Apache Drill REST API documentation:", url="https://drill.apache.org/docs/rest-api-introduction/"))
    @Deprecated
    public Response enablePluginViaGet(@PathParam(value="name") String name, @PathParam(value="val") Boolean enable) {
        return this.enablePlugin(name, enable);
    }

    @GET
    @Path(value="/storage/{name}/export{format: (/[^/]+?)*}")
    @Produces(value={"application/json"})
    public Response exportPlugin(@PathParam(value="name") String name, @PathParam(value="format") String format) {
        String string = format = StringUtils.isNotEmpty((CharSequence)format) ? format.replace("/", "") : JSON_FORMAT;
        if (!this.isSupported(format)) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)this.message("Unknown \"%s\" file format for Storage Plugin config", format)).build();
        }
        return Response.ok((Object)new PluginConfigWrapper(name, this.storage.getStoredConfig(name))).header("Content-Disposition", (Object)String.format("attachment;filename=\"%s.%s\"", name, format)).build();
    }

    @DELETE
    @Path(value="/storage/{name}.json")
    @Produces(value={"application/json"})
    @Operation(externalDocs=@ExternalDocumentation(description="Apache Drill REST API documentation:", url="https://drill.apache.org/docs/rest-api-introduction/"))
    public Response deletePlugin(@PathParam(value="name") String name) {
        try {
            TokenRegistry tokenRegistry = this.workManager.getContext().getOauthTokenProvider().getOauthTokenRegistry(this.getQueryUser(this.storage.getStoredConfig(name)));
            tokenRegistry.deleteTokenTable(name);
            this.storage.remove(name);
            return Response.ok().entity((Object)this.message("Success", new Object[0])).build();
        }
        catch (StoragePluginRegistry.PluginException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.message("Error while deleting plugin: %s", e.getMessage())).build();
        }
    }

    @POST
    @Path(value="/storage/{name}.json")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(externalDocs=@ExternalDocumentation(description="Apache Drill REST API documentation:", url="https://drill.apache.org/docs/rest-api-introduction/"))
    public Response createOrUpdatePluginJSON(PluginConfigWrapper plugin) {
        try {
            plugin.createOrUpdateInStorage(this.storage);
            return Response.ok().entity((Object)this.message("Success", new Object[0])).build();
        }
        catch (StoragePluginRegistry.PluginException e) {
            logger.error("Unable to create/ update plugin: " + plugin.getName(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.message("Error while saving plugin: %s ", e.getMessage())).build();
        }
    }

    @POST
    @Path(value="/storage/create_update")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response createOrUpdatePlugin(@FormParam(value="name") String name, @FormParam(value="config") String storagePluginConfig) {
        if ((name = name.trim()).isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.message("A storage config name may not be empty", new Object[0])).build();
        }
        try {
            this.storage.putJson(name, storagePluginConfig);
            return Response.ok().entity((Object)this.message("Success", new Object[0])).build();
        }
        catch (StoragePluginRegistry.PluginEncodingException e) {
            logger.warn("Error in JSON mapping: {}", (Object)storagePluginConfig, (Object)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.message("Invalid JSON: %s", e.getMessage())).build();
        }
        catch (StoragePluginRegistry.PluginException e) {
            logger.error("Error while saving plugin", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.message("Error while saving plugin: %s", e.getMessage())).build();
        }
    }

    private JsonResult message(String message, Object ... args) {
        return new JsonResult(String.format(message, args));
    }

    private boolean isSupported(String format) {
        return JSON_FORMAT.equalsIgnoreCase(format) || HOCON_FORMAT.equalsIgnoreCase(format);
    }

    @GET
    @Path(value="/storage{group: (/[^/]+?)*}-plugins.json")
    @Produces(value={"application/json"})
    public List<PluginConfigWrapper> getConfigsFor(@PathParam(value="group") String pluginGroup) {
        StoragePluginRegistry.PluginFilter filter;
        switch (pluginGroup.trim()) {
            case "all": {
                filter = StoragePluginRegistry.PluginFilter.ALL;
                break;
            }
            case "enabled": {
                filter = StoragePluginRegistry.PluginFilter.ENABLED;
                break;
            }
            case "disabled": {
                filter = StoragePluginRegistry.PluginFilter.DISABLED;
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        pluginGroup = StringUtils.isNotEmpty((CharSequence)pluginGroup) ? pluginGroup.replace("/", "") : ALL_PLUGINS;
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.storage.storedConfigs(filter).entrySet().iterator(), 16), false).map(entry -> new PluginConfigWrapper((String)entry.getKey(), (StoragePluginConfig)entry.getValue())).sorted(PLUGIN_COMPARATOR).collect(Collectors.toList());
    }

    @POST
    @Path(value="/storage/{name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Deprecated
    public Response createOrUpdatePlugin(PluginConfigWrapper plugin) {
        return this.createOrUpdatePluginJSON(plugin);
    }

    @GET
    @Path(value="/storage/{name}/delete")
    @Produces(value={"application/json"})
    @Deprecated
    public Response deletePluginViaGet(@PathParam(value="name") String name) {
        return this.deletePlugin(name);
    }

    private String getQueryUser(StoragePluginConfig config) {
        if (config.getAuthMode() == StoragePluginConfig.AuthMode.USER_TRANSLATION && this.authEnabled.get()) {
            return this.sc.getUserPrincipal().getName();
        }
        return null;
    }

    @XmlRootElement
    public static class JsonResult {
        private final String result;

        public JsonResult(String result) {
            this.result = result;
        }

        public String getResult() {
            return this.result;
        }
    }

    public static class StoragePluginModel {
        private final PluginConfigWrapper plugin;
        private final String type;
        private final String csrfToken;
        private final SecurityContext securityContext;

        public StoragePluginModel(PluginConfigWrapper plugin, HttpServletRequest request, SecurityContext sc) {
            this.plugin = plugin;
            this.type = plugin != null ? plugin.getConfig().getClass().getSimpleName() : "Unknown";
            this.csrfToken = WebUtils.getCsrfTokenFromHttpRequest(request);
            this.securityContext = sc;
        }

        public String getActiveUser() {
            return this.securityContext.getUserPrincipal().getName();
        }

        public String getUserName() {
            String username = this.plugin.getUserName(this.getActiveUser());
            if (StringUtils.isEmpty((CharSequence)username)) {
                return "";
            }
            return username;
        }

        public String getPassword() {
            String password = this.plugin.getPassword(this.getActiveUser());
            if (StringUtils.isEmpty((CharSequence)password)) {
                return "";
            }
            return password;
        }

        public String getType() {
            return this.type;
        }

        public PluginConfigWrapper getPlugin() {
            return this.plugin;
        }

        public String getCsrfToken() {
            return this.csrfToken;
        }
    }
}

