/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest;

import java.util.Map;
import javax.ws.rs.core.SecurityContext;
import org.apache.drill.exec.server.rest.auth.AuthDynamicFeature;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.glassfish.jersey.server.mvc.Viewable;

public class ViewableWithPermissions
extends Viewable {
    public static Viewable create(boolean authEnabled, String templateName, SecurityContext sc) {
        return new ViewableWithPermissions(authEnabled, templateName, sc, true, null);
    }

    public static Viewable create(boolean authEnabled, String templateName, SecurityContext sc, Object model) {
        return new ViewableWithPermissions(authEnabled, templateName, sc, true, model);
    }

    public static Viewable createLoginPage(String errorMsg) {
        return new ViewableWithPermissions(true, "/rest/login.ftl", null, false, errorMsg);
    }

    public static Viewable createMainLoginPage(Object mainPageModel) {
        return new ViewableWithPermissions(true, "/rest/mainLogin.ftl", null, false, mainPageModel);
    }

    private ViewableWithPermissions(boolean authEnabled, String templateName, SecurityContext sc, boolean showControls, Object model) throws IllegalArgumentException {
        super(templateName, ViewableWithPermissions.createModel(authEnabled, sc, showControls, model));
    }

    private static Map<String, Object> createModel(boolean authEnabled, SecurityContext sc, boolean showControls, Object pageModel) {
        boolean isAdmin = !authEnabled || showControls && sc.isUserInRole("admin");
        boolean isUserLoggedIn = AuthDynamicFeature.isUserLoggedIn(sc);
        boolean showCredentials = authEnabled && isUserLoggedIn;
        ImmutableMap.Builder<String, Boolean> mapBuilder = ImmutableMap.builder().put("showStorage", isAdmin).put("showCredentials", showCredentials).put("showOptions", isAdmin).put("showThreads", isAdmin).put("showLogs", isAdmin).put("showLogin", authEnabled && showControls && !isUserLoggedIn).put("showLogout", authEnabled && showControls && isUserLoggedIn).put("loggedInUserName", (Boolean)((Object)(authEnabled && showControls && isUserLoggedIn ? sc.getUserPrincipal().getName() : "anonymous"))).put("showControls", showControls);
        if (pageModel != null) {
            mapBuilder.put("model", (Boolean)pageModel);
        }
        return mapBuilder.build();
    }
}

