/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest;

import io.netty.util.concurrent.Promise;
import java.net.SocketAddress;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.rpc.ChannelClosedException;
import org.apache.drill.exec.rpc.user.UserSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSessionResources
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(WebSessionResources.class);
    private final BufferAllocator allocator;
    private final SocketAddress remoteAddress;
    private final UserSession webUserSession;
    private Promise<Void> closeFuture;

    WebSessionResources(BufferAllocator allocator, SocketAddress remoteAddress, UserSession userSession, Promise<Void> closeFuture) {
        this.allocator = allocator;
        this.remoteAddress = remoteAddress;
        this.webUserSession = userSession;
        this.closeFuture = closeFuture;
    }

    public UserSession getSession() {
        return this.webUserSession;
    }

    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    public Promise<Void> getCloseFuture() {
        return this.closeFuture;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public void close() {
        try {
            AutoCloseables.close(this.webUserSession, this.allocator);
        }
        catch (Exception ex) {
            logger.error("Failure while closing the session resources", (Throwable)ex);
        }
        if (this.closeFuture != null) {
            this.closeFuture.setFailure(new ChannelClosedException("Http connection is closed by Web Client"));
            this.closeFuture = null;
        }
    }
}

