/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.work.WorkManager;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class WebUtils {
    private static CloseableHttpAsyncClient httpClient;

    public static String getCsrfTokenFromHttpRequest(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        return session == null ? "" : (String)session.getAttribute("csrfToken");
    }

    public static String generateCsrfToken() {
        byte[] buffer = new byte[32];
        new SecureRandom().nextBytes(buffer);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(buffer);
    }

    static URL getDrillbitURL(WorkManager work, HttpServletRequest request, String hostname, String path) {
        int drillbitPort = work.getContext().getAvailableBits().stream().filter(db -> db.getAddress().equals(hostname)).findAny().map(CoordinationProtos.DrillbitEndpoint::getHttpPort).orElseThrow(() -> new RuntimeException("No such drillbit: " + hostname));
        try {
            return new URL(request.getScheme(), hostname, drillbitPort, path);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Should never occur", e);
        }
    }

    static String doHTTPRequest(HttpRequestBase httpRequest, DrillConfig drillConfig) throws Exception {
        CloseableHttpAsyncClient httpClient = WebUtils.getHttpClient(drillConfig);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(((HttpResponse)httpClient.execute((HttpUriRequest)httpRequest, null).get()).getEntity().getContent()));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CloseableHttpAsyncClient getHttpClient(DrillConfig drillConfig) throws Exception {
        CloseableHttpAsyncClient localHttpClient = httpClient;
        if (localHttpClient != null) return localHttpClient;
        Class<WebUtils> clazz = WebUtils.class;
        synchronized (WebUtils.class) {
            localHttpClient = httpClient;
            if (httpClient != null) return localHttpClient;
            localHttpClient = WebUtils.createHttpClient(drillConfig);
            localHttpClient.start();
            httpClient = localHttpClient;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return localHttpClient;
        }
    }

    private static CloseableHttpAsyncClient createHttpClient(DrillConfig drillConfig) throws Exception {
        HttpAsyncClientBuilder clientBuilder = HttpAsyncClients.custom();
        if (drillConfig.getBoolean("drill.exec.http.ssl_enabled")) {
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build();
            SSLIOSessionStrategy sessionStrategy = new SSLIOSessionStrategy(sslContext, new String[]{drillConfig.getString("drill.exec.ssl.protocol")}, null, SSLIOSessionStrategy.getDefaultHostnameVerifier());
            clientBuilder.setSSLStrategy((SchemeIOSessionStrategy)sessionStrategy);
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(drillConfig.getInt("drill.exec.http.client.timeout")).build();
        clientBuilder.setDefaultRequestConfig(requestConfig);
        return clientBuilder.build();
    }
}

