/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest.auth;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.DrillException;
import org.apache.drill.common.map.CaseInsensitiveMap;
import org.apache.drill.common.scanner.persistence.ScanResult;
import org.apache.drill.exec.exception.DrillbitStartupException;
import org.apache.drill.exec.rpc.security.AuthStringUtil;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.rest.auth.DrillHttpConstraintSecurityHandler;
import org.apache.drill.exec.server.rest.header.ResponseHeadersSettingFilter;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.authentication.SessionAuthentication;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillHttpSecurityHandlerProvider
extends ConstraintSecurityHandler {
    private static final Logger logger = LoggerFactory.getLogger(DrillHttpSecurityHandlerProvider.class);
    private final Map<String, DrillHttpConstraintSecurityHandler> securityHandlers = CaseInsensitiveMap.newHashMapWithExpectedSize(2);
    private final Map<String, String> responseHeaders;

    public DrillHttpSecurityHandlerProvider(DrillConfig config, DrillbitContext drillContext) throws DrillbitStartupException {
        Preconditions.checkState(config.getBoolean("drill.exec.security.user.auth.enabled"));
        this.responseHeaders = ResponseHeadersSettingFilter.retrieveResponseHeaders(config);
        Set<String> configuredMechanisms = DrillHttpSecurityHandlerProvider.getHttpAuthMechanisms(config);
        ScanResult scan = drillContext.getClasspathScan();
        Set<Class<DrillHttpConstraintSecurityHandler>> factoryImpls = scan.getImplementations(DrillHttpConstraintSecurityHandler.class);
        logger.debug("Found DrillHttpConstraintSecurityHandler implementations: {}", factoryImpls);
        for (Class clazz : factoryImpls) {
            if (configuredMechanisms.isEmpty()) break;
            Constructor<?> validConstructor = null;
            for (Constructor<?> c : clazz.getConstructors()) {
                Class<?>[] params = c.getParameterTypes();
                if (params.length != 0) continue;
                validConstructor = c;
                break;
            }
            if (validConstructor == null) {
                logger.warn("Skipping DrillHttpConstraintSecurityHandler class {}. It must implement at least one constructor with signature [{}()]", (Object)clazz.getCanonicalName(), (Object)clazz.getName());
                continue;
            }
            try {
                DrillHttpConstraintSecurityHandler instance = (DrillHttpConstraintSecurityHandler)((Object)validConstructor.newInstance(new Object[0]));
                if (!configuredMechanisms.remove(instance.getImplName())) continue;
                instance.doSetup(drillContext);
                this.securityHandlers.put(instance.getImplName(), instance);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | DrillException e) {
                logger.warn(String.format("Failed to create DrillHttpConstraintSecurityHandler of type '%s'", clazz.getCanonicalName()), (Throwable)e);
            }
        }
        if (this.securityHandlers.size() == 0) {
            throw new DrillbitStartupException("Authentication is enabled for WebServer but none of the security mechanism was configured properly. Please verify the configurations and try again.");
        }
        logger.info("Configure auth mechanisms for WebServer are: {}", this.securityHandlers.keySet());
    }

    public void doStart() throws Exception {
        super.doStart();
        for (DrillHttpConstraintSecurityHandler securityHandler : this.securityHandlers.values()) {
            securityHandler.doStart();
        }
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Preconditions.checkState(this.securityHandlers.size() > 0);
        this.responseHeaders.forEach((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1));
        HttpSession session = request.getSession(true);
        SessionAuthentication authentication = (SessionAuthentication)session.getAttribute("org.eclipse.jetty.security.UserIdentity");
        String uri = request.getRequestURI();
        if (authentication == null) {
            if (this.isSpnegoEnabled() && (!this.isFormEnabled() || uri.equals("/spnegoLogin"))) {
                DrillHttpConstraintSecurityHandler securityHandler = this.securityHandlers.get("SPNEGO");
                securityHandler.handle(target, baseRequest, request, response);
            } else if (this.isBasicEnabled() && request.getHeader(HttpHeader.AUTHORIZATION.asString()) != null) {
                DrillHttpConstraintSecurityHandler securityHandler = this.securityHandlers.get("BASIC");
                securityHandler.handle(target, baseRequest, request, response);
            } else if (this.isFormEnabled()) {
                DrillHttpConstraintSecurityHandler securityHandler = this.securityHandlers.get("FORM");
                securityHandler.handle(target, baseRequest, request, response);
            }
        } else {
            String authMethod = authentication.getAuthMethod();
            DrillHttpConstraintSecurityHandler securityHandler = this.securityHandlers.get(authMethod);
            securityHandler.handle(target, baseRequest, request, response);
        }
    }

    public void setHandler(Handler handler) {
        super.setHandler(handler);
        for (DrillHttpConstraintSecurityHandler securityHandler : this.securityHandlers.values()) {
            securityHandler.setHandler(handler);
        }
    }

    public void doStop() throws Exception {
        super.doStop();
        for (DrillHttpConstraintSecurityHandler securityHandler : this.securityHandlers.values()) {
            securityHandler.doStop();
        }
    }

    public boolean isSpnegoEnabled() {
        return this.securityHandlers.containsKey("SPNEGO");
    }

    public boolean isFormEnabled() {
        return this.securityHandlers.containsKey("FORM");
    }

    public boolean isBasicEnabled() {
        return this.securityHandlers.containsKey("BASIC");
    }

    public static Set<String> getHttpAuthMechanisms(DrillConfig config) {
        HashSet<String> configuredMechs = new HashSet<String>();
        boolean authEnabled = config.getBoolean("drill.exec.security.user.auth.enabled");
        if (authEnabled) {
            if (config.hasPath("drill.exec.http.auth.mechanisms")) {
                configuredMechs.addAll(AuthStringUtil.asSet(config.getStringList("drill.exec.http.auth.mechanisms")));
            } else {
                configuredMechs.add("FORM");
            }
        }
        return configuredMechs;
    }
}

