/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest.auth;

import java.io.IOException;
import java.lang.reflect.Field;
import java.security.Principal;
import java.util.Base64;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import org.apache.drill.common.exceptions.DrillException;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.options.SystemOptionManager;
import org.apache.drill.exec.server.rest.auth.DrillUserPrincipal;
import org.apache.drill.exec.server.rest.auth.SpnegoConfig;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.hadoop.security.HadoopKerberosName;
import org.apache.hadoop.security.UserGroupInformation;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.SpnegoLoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillSpnegoLoginService
extends SpnegoLoginService {
    private static final Logger logger = LoggerFactory.getLogger(DrillSpnegoLoginService.class);
    private static final String TARGET_NAME_FIELD_NAME = "_targetName";
    private final DrillbitContext drillContext;
    private final SpnegoConfig spnegoConfig;
    private final UserGroupInformation loggedInUgi;

    public DrillSpnegoLoginService(DrillbitContext drillBitContext) throws DrillException {
        super(DrillSpnegoLoginService.class.getName());
        this.setIdentityService((IdentityService)new DefaultIdentityService());
        this.drillContext = drillBitContext;
        this.spnegoConfig = new SpnegoConfig(drillBitContext.getConfig());
        this.spnegoConfig.validateSpnegoConfig();
        this.loggedInUgi = this.spnegoConfig.getLoggedInUgi();
    }

    protected void doStart() throws Exception {
        Field targetNameField = SpnegoLoginService.class.getDeclaredField(TARGET_NAME_FIELD_NAME);
        targetNameField.setAccessible(true);
        targetNameField.set((Object)this, this.spnegoConfig.getSpnegoPrincipal());
    }

    public UserIdentity login(String username, Object credentials, ServletRequest request) {
        UserIdentity identity = null;
        try {
            identity = (UserIdentity)this.loggedInUgi.doAs(() -> this.spnegoLogin(credentials, request));
        }
        catch (Exception e) {
            logger.error("Failed to login using SPNEGO", (Throwable)e);
        }
        return identity;
    }

    private UserIdentity spnegoLogin(Object credentials, ServletRequest request) {
        String encodedAuthToken = (String)credentials;
        byte[] authToken = Base64.getDecoder().decode(encodedAuthToken);
        GSSManager manager = GSSManager.getInstance();
        try {
            Oid[] knownOids = new Oid[]{new Oid("1.3.6.1.5.5.2"), new Oid("1.2.840.113554.1.2.2")};
            GSSName gssName = manager.createName(this.spnegoConfig.getSpnegoPrincipal(), null);
            GSSCredential serverCreds = manager.createCredential(gssName, Integer.MAX_VALUE, knownOids, 2);
            GSSContext gContext = manager.createContext(serverCreds);
            if (gContext == null) {
                logger.debug("SPNEGOUserRealm: failed to establish GSSContext");
            } else {
                while (!gContext.isEstablished()) {
                    authToken = gContext.acceptSecContext(authToken, 0, authToken.length);
                }
                if (gContext.isEstablished()) {
                    String clientName = gContext.getSrcName().toString();
                    String realm = clientName.substring(clientName.indexOf(64) + 1);
                    String userShortName = new HadoopKerberosName(clientName).getShortName();
                    logger.info("WebUser {} logged in from {}:{}", new Object[]{userShortName, request.getRemoteHost(), request.getRemotePort()});
                    logger.debug("Client Name: {}, realm: {} and shortName: {}", new Object[]{clientName, realm, userShortName});
                    SystemOptionManager sysOptions = this.drillContext.getOptionManager();
                    boolean isAdmin = ImpersonationUtil.hasAdminPrivileges(userShortName, ExecConstants.ADMIN_USERS_VALIDATOR.getAdminUsers(sysOptions), ExecConstants.ADMIN_USER_GROUPS_VALIDATOR.getAdminUserGroups(sysOptions));
                    DrillUserPrincipal user = new DrillUserPrincipal(userShortName, isAdmin);
                    Subject subject = new Subject();
                    subject.getPrincipals().add(user);
                    if (isAdmin) {
                        return this._identityService.newUserIdentity(subject, (Principal)user, DrillUserPrincipal.ADMIN_USER_ROLES);
                    }
                    return this._identityService.newUserIdentity(subject, (Principal)user, DrillUserPrincipal.NON_ADMIN_USER_ROLES);
                }
            }
        }
        catch (GSSException gsse) {
            logger.warn("Caught GSSException trying to authenticate the client", (Throwable)gsse);
        }
        catch (IOException ex) {
            logger.warn("Caught IOException trying to get shortName of client user", (Throwable)ex);
        }
        return null;
    }
}

