/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest.auth;

import java.security.Principal;
import java.util.List;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.eclipse.jetty.security.AbstractLoginService;

public class DrillUserPrincipal
implements Principal {
    public static final String ANONYMOUS_USER = "anonymous";
    public static final String AUTHENTICATED_ROLE = "authenticated";
    public static final String ADMIN_ROLE = "admin";
    public static final String[] ADMIN_USER_ROLES = new String[]{"authenticated", "admin"};
    public static final String[] NON_ADMIN_USER_ROLES = new String[]{"authenticated"};
    public static final List<AbstractLoginService.RolePrincipal> ADMIN_PRINCIPALS = ImmutableList.of(new AbstractLoginService.RolePrincipal("authenticated"), new AbstractLoginService.RolePrincipal("admin"));
    public static final List<AbstractLoginService.RolePrincipal> NON_ADMIN_PRINCIPALS = ImmutableList.of(new AbstractLoginService.RolePrincipal("authenticated"));
    private final String userName;
    private final boolean isAdmin;

    public DrillUserPrincipal(String userName, boolean isAdmin) {
        this.userName = userName;
        this.isAdmin = isAdmin;
    }

    public boolean isAdminUser() {
        return this.isAdmin;
    }

    @Override
    public String getName() {
        return this.userName;
    }

    public boolean canManageProfileOf(String profileOwner) {
        return this.isAdmin || this.userName.equals(profileOwner);
    }

    public boolean canManageQueryOf(String queryUser) {
        return this.isAdmin || this.userName.equals(queryUser);
    }

    public static class AnonDrillUserPrincipal
    extends DrillUserPrincipal {
        public AnonDrillUserPrincipal() {
            super(DrillUserPrincipal.ANONYMOUS_USER, true);
        }
    }
}

