/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest.profile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.server.rest.profile.Comparators;
import org.apache.drill.exec.server.rest.profile.Filters;
import org.apache.drill.exec.server.rest.profile.OperatorPathBuilder;
import org.apache.drill.exec.server.rest.profile.TableBuilder;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Collections2;

public class FragmentWrapper {
    private final UserBitShared.MajorFragmentProfile major;
    private final long start;
    private final int runningProfileProgressThreshold;
    public static final String[] ACTIVE_FRAGMENT_OVERVIEW_COLUMNS = new String[]{"Major Fragment", "Minor Fragments Reporting", "First Start", "Last Start", "First End", "Last End", "Min Runtime", "Avg Runtime", "Max Runtime", "% Busy", "Last Update", "Last Progress", "Max Peak Memory"};
    public static final String[] ACTIVE_FRAGMENT_OVERVIEW_COLUMNS_TOOLTIP = new String[]{"Major fragment ID seen in the visual plan", "Number of minor fragments started", "Time at which the first fragment started", "Time at which the last fragment started", "Time at which the first fragment completed", "Time at which the last fragment completed", "Shortest fragment runtime", "Average fragment runtime", "Longest fragment runtime", "Percentage of run time that fragments were busy doing work", "Time since most recent heartbeat from a fragment", "Time since most recent update from a fragment", "Highest memory consumption by a fragment"};
    public static final int NUM_NULLABLE_ACTIVE_OVERVIEW_COLUMNS = ACTIVE_FRAGMENT_OVERVIEW_COLUMNS.length - 2;
    public static final String[] COMPLETED_FRAGMENT_OVERVIEW_COLUMNS = new String[]{"Major Fragment", "Minor Fragments Reporting", "First Start", "Last Start", "First End", "Last End", "Min Runtime", "Avg Runtime", "Max Runtime", "% Busy", "Max Peak Memory"};
    public static final String[] COMPLETED_FRAGMENT_OVERVIEW_COLUMNS_TOOLTIP = new String[]{"Major fragment ID seen in the visual plan", "Number of minor fragments started", "Time at which the first fragment started", "Time at which the last fragment started", "Time at which the first fragment completed", "Time at which the last fragment completed", "Shortest fragment runtime", "Average fragment runtime", "Longest fragment runtime", "Percentage of run time that fragments were busy doing work", "Highest memory consumption by a fragment"};
    public static final int NUM_NULLABLE_COMPLETED_OVERVIEW_COLUMNS = COMPLETED_FRAGMENT_OVERVIEW_COLUMNS.length - 2;
    public static final String[] FRAGMENT_COLUMNS = new String[]{"Minor Fragment", "Hostname", "Start", "End", "Runtime", "Max Records", "Max Batches", "Last Update", "Last Progress", "Peak Memory", "State"};
    public static final String[] FRAGMENT_COLUMNS_TOOLTIP = new String[]{"Minor Fragment ID", "Host on which the fragment ran", "Fragment Start Time", "Fragment End Time", "Duration of the Fragment", "Max Batches processed by the fragment", "Max Records processed by the fragment", "Last time fragment reported heartbeat", "Last time fragment reported back metrics", "Fragment Peak Memory Usage", "State of the fragment"};
    private static final int NUM_NULLABLE_FRAGMENTS_COLUMNS = FRAGMENT_COLUMNS.length - 1;

    public FragmentWrapper(UserBitShared.MajorFragmentProfile major, long start, DrillConfig config) {
        this.major = Preconditions.checkNotNull(major);
        this.start = start;
        this.runningProfileProgressThreshold = config.getInt("drill.exec.http.profile.warning.progress.threshold");
    }

    public String getDisplayName() {
        return String.format("Major Fragment: %s", new OperatorPathBuilder().setMajor(this.major).build());
    }

    public String getId() {
        return String.format("fragment-%s", this.major.getMajorFragmentId());
    }

    public void addSummary(TableBuilder tb) {
        ArrayList<UserBitShared.MinorFragmentProfile> complete = new ArrayList<UserBitShared.MinorFragmentProfile>(Collections2.filter(this.major.getMinorFragmentProfileList(), Filters.hasOperatorsAndTimes));
        tb.appendCell(new OperatorPathBuilder().setMajor(this.major).build());
        tb.appendCell(complete.size() + " / " + this.major.getMinorFragmentProfileCount());
        if (complete.size() < 1) {
            tb.appendRepeated("", NUM_NULLABLE_ACTIVE_OVERVIEW_COLUMNS);
            return;
        }
        UserBitShared.MinorFragmentProfile firstStart = Collections.min(complete, Comparators.startTime);
        UserBitShared.MinorFragmentProfile lastStart = Collections.max(complete, Comparators.startTime);
        tb.appendMillis(firstStart.getStartTime() - this.start);
        tb.appendMillis(lastStart.getStartTime() - this.start);
        UserBitShared.MinorFragmentProfile firstEnd = Collections.min(complete, Comparators.endTime);
        UserBitShared.MinorFragmentProfile lastEnd = Collections.max(complete, Comparators.endTime);
        tb.appendMillis(firstEnd.getEndTime() - this.start);
        tb.appendMillis(lastEnd.getEndTime() - this.start);
        long cumulativeFragmentDurationInMillis = 0L;
        long cumulativeProcessInNanos = 0L;
        long cumulativeWaitInNanos = 0L;
        for (UserBitShared.MinorFragmentProfile p : complete) {
            cumulativeFragmentDurationInMillis += p.getEndTime() - p.getStartTime();
            List<UserBitShared.OperatorProfile> opProfileList = p.getOperatorProfileList();
            for (UserBitShared.OperatorProfile operatorProfile : opProfileList) {
                cumulativeProcessInNanos += operatorProfile.getProcessNanos();
                cumulativeWaitInNanos += operatorProfile.getWaitNanos();
            }
        }
        double totalProcessInMillis = Math.round((double)cumulativeProcessInNanos / 1000000.0);
        double totalWaitInMillis = Math.round((double)cumulativeWaitInNanos / 1000000.0);
        UserBitShared.MinorFragmentProfile shortRun = Collections.min(complete, Comparators.runTime);
        UserBitShared.MinorFragmentProfile longRun = Collections.max(complete, Comparators.runTime);
        tb.appendMillis(shortRun.getEndTime() - shortRun.getStartTime());
        tb.appendMillis(cumulativeFragmentDurationInMillis / (long)complete.size());
        tb.appendMillis(longRun.getEndTime() - longRun.getStartTime());
        HashMap<String, String> percBusyAttrMap = new HashMap<String, String>();
        percBusyAttrMap.put("title", String.format("&#8721;Busy: %,.2fs + &#8721;Wait: %,.2fs", totalProcessInMillis / 1000.0, totalWaitInMillis / 1000.0));
        tb.appendPercent(totalProcessInMillis / (totalProcessInMillis + totalWaitInMillis), percBusyAttrMap);
        UserBitShared.MinorFragmentProfile lastUpdate = Collections.max(complete, Comparators.lastUpdate);
        tb.appendMillis(System.currentTimeMillis() - lastUpdate.getLastUpdate());
        UserBitShared.MinorFragmentProfile lastProgress = Collections.max(complete, Comparators.lastProgress);
        long elapsedSinceLastProgress = System.currentTimeMillis() - lastProgress.getLastProgress();
        HashMap<String, String> lastProgressAttrMap = null;
        if (elapsedSinceLastProgress > TimeUnit.SECONDS.toMillis(this.runningProfileProgressThreshold)) {
            lastProgressAttrMap = new HashMap<String, String>();
            lastProgressAttrMap.put("class", "no-progress-tag");
        }
        tb.appendMillis(elapsedSinceLastProgress, lastProgressAttrMap);
        UserBitShared.MinorFragmentProfile maxMem = Collections.max(complete, Comparators.fragmentPeakMemory);
        tb.appendBytes(maxMem.getMaxMemoryUsed());
    }

    public void addFinalSummary(TableBuilder tb) {
        ArrayList<UserBitShared.MinorFragmentProfile> complete = new ArrayList<UserBitShared.MinorFragmentProfile>(Collections2.filter(this.major.getMinorFragmentProfileList(), Filters.hasOperatorsAndTimes));
        tb.appendCell(new OperatorPathBuilder().setMajor(this.major).build());
        tb.appendCell(complete.size() + " / " + this.major.getMinorFragmentProfileCount());
        if (complete.size() < 1) {
            tb.appendRepeated("", NUM_NULLABLE_COMPLETED_OVERVIEW_COLUMNS);
            return;
        }
        UserBitShared.MinorFragmentProfile firstStart = Collections.min(complete, Comparators.startTime);
        UserBitShared.MinorFragmentProfile lastStart = Collections.max(complete, Comparators.startTime);
        tb.appendMillis(firstStart.getStartTime() - this.start);
        tb.appendMillis(lastStart.getStartTime() - this.start);
        UserBitShared.MinorFragmentProfile firstEnd = Collections.min(complete, Comparators.endTime);
        UserBitShared.MinorFragmentProfile lastEnd = Collections.max(complete, Comparators.endTime);
        tb.appendMillis(firstEnd.getEndTime() - this.start);
        tb.appendMillis(lastEnd.getEndTime() - this.start);
        long totalDuration = 0L;
        double totalProcessInMillis = 0.0;
        double totalWaitInMillis = 0.0;
        for (UserBitShared.MinorFragmentProfile p : complete) {
            totalDuration += p.getEndTime() - p.getStartTime();
            List<UserBitShared.OperatorProfile> opProfileList = p.getOperatorProfileList();
            for (UserBitShared.OperatorProfile operatorProfile : opProfileList) {
                totalProcessInMillis += (double)operatorProfile.getProcessNanos() / 1000000.0;
                totalWaitInMillis += (double)operatorProfile.getWaitNanos() / 1000000.0;
            }
        }
        UserBitShared.MinorFragmentProfile shortRun = Collections.min(complete, Comparators.runTime);
        UserBitShared.MinorFragmentProfile longRun = Collections.max(complete, Comparators.runTime);
        tb.appendMillis(shortRun.getEndTime() - shortRun.getStartTime());
        tb.appendMillis(totalDuration / (long)complete.size());
        tb.appendMillis(longRun.getEndTime() - longRun.getStartTime());
        HashMap<String, String> percBusyAttrMap = new HashMap<String, String>();
        percBusyAttrMap.put("title", String.format("&#8721;Busy: %,.2fs + &#8721;Wait: %,.2fs", totalProcessInMillis / 1000.0, totalWaitInMillis / 1000.0));
        tb.appendPercent(totalProcessInMillis / (totalProcessInMillis + totalWaitInMillis), percBusyAttrMap);
        UserBitShared.MinorFragmentProfile maxMem = Collections.max(complete, Comparators.fragmentPeakMemory);
        tb.appendBytes(maxMem.getMaxMemoryUsed());
    }

    public String getContent() {
        TableBuilder builder = new TableBuilder(FRAGMENT_COLUMNS, FRAGMENT_COLUMNS_TOOLTIP, true);
        ArrayList<UserBitShared.MinorFragmentProfile> complete = new ArrayList<UserBitShared.MinorFragmentProfile>(Collections2.filter(this.major.getMinorFragmentProfileList(), Filters.hasOperatorsAndTimes));
        ArrayList<UserBitShared.MinorFragmentProfile> incomplete = new ArrayList<UserBitShared.MinorFragmentProfile>(Collections2.filter(this.major.getMinorFragmentProfileList(), Filters.missingOperatorsOrTimes));
        Collections.sort(complete, Comparators.minorId);
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        for (UserBitShared.MinorFragmentProfile minor : complete) {
            ArrayList<UserBitShared.OperatorProfile> ops = new ArrayList<UserBitShared.OperatorProfile>(minor.getOperatorProfileList());
            long biggestIncomingRecords = 0L;
            long biggestBatches = 0L;
            for (UserBitShared.OperatorProfile op : ops) {
                long incomingRecords = 0L;
                long batches = 0L;
                for (UserBitShared.StreamProfile sp : op.getInputProfileList()) {
                    incomingRecords += sp.getRecords();
                    batches += sp.getBatches();
                }
                biggestIncomingRecords = Math.max(biggestIncomingRecords, incomingRecords);
                biggestBatches = Math.max(biggestBatches, batches);
            }
            attributeMap.put("data-order", String.valueOf(minor.getMinorFragmentId()));
            builder.appendCell(new OperatorPathBuilder().setMajor(this.major).setMinor(minor).build(), attributeMap);
            builder.appendCell(minor.getEndpoint().getAddress());
            builder.appendMillis(minor.getStartTime() - this.start);
            builder.appendMillis(minor.getEndTime() - this.start);
            builder.appendMillis(minor.getEndTime() - minor.getStartTime());
            builder.appendFormattedInteger(biggestIncomingRecords);
            builder.appendFormattedInteger(biggestBatches);
            builder.appendTime(minor.getLastUpdate());
            builder.appendTime(minor.getLastProgress());
            builder.appendBytes(minor.getMaxMemoryUsed());
            builder.appendCell(minor.getState().name());
        }
        for (UserBitShared.MinorFragmentProfile m : incomplete) {
            builder.appendCell(this.major.getMajorFragmentId() + "-" + m.getMinorFragmentId());
            builder.appendRepeated(m.getState().toString(), NUM_NULLABLE_FRAGMENTS_COLUMNS);
        }
        return builder.build();
    }

    private class OverviewTblTxt {
        static final String MAJOR_FRAGMENT = "Major Fragment";
        static final String MINOR_FRAGMENTS_REPORTING = "Minor Fragments Reporting";
        static final String FIRST_START = "First Start";
        static final String LAST_START = "Last Start";
        static final String FIRST_END = "First End";
        static final String LAST_END = "Last End";
        static final String MIN_RUNTIME = "Min Runtime";
        static final String AVG_RUNTIME = "Avg Runtime";
        static final String MAX_RUNTIME = "Max Runtime";
        static final String PERCENT_BUSY = "% Busy";
        static final String LAST_UPDATE = "Last Update";
        static final String LAST_PROGRESS = "Last Progress";
        static final String MAX_PEAK_MEMORY = "Max Peak Memory";

        private OverviewTblTxt() {
        }
    }

    private class OverviewTblTooltip {
        static final String MAJOR_FRAGMENT = "Major fragment ID seen in the visual plan";
        static final String MINOR_FRAGMENTS_REPORTING = "Number of minor fragments started";
        static final String FIRST_START = "Time at which the first fragment started";
        static final String LAST_START = "Time at which the last fragment started";
        static final String FIRST_END = "Time at which the first fragment completed";
        static final String LAST_END = "Time at which the last fragment completed";
        static final String MIN_RUNTIME = "Shortest fragment runtime";
        static final String AVG_RUNTIME = "Average fragment runtime";
        static final String MAX_RUNTIME = "Longest fragment runtime";
        static final String PERCENT_BUSY = "Percentage of run time that fragments were busy doing work";
        static final String LAST_UPDATE = "Time since most recent heartbeat from a fragment";
        static final String LAST_PROGRESS = "Time since most recent update from a fragment";
        static final String MAX_PEAK_MEMORY = "Highest memory consumption by a fragment";

        private OverviewTblTooltip() {
        }
    }

    private class FragmentTblTxt {
        static final String MINOR_FRAGMENT = "Minor Fragment";
        static final String HOSTNAME = "Hostname";
        static final String START_TIME = "Start";
        static final String END_TIME = "End";
        static final String RUNTIME = "Runtime";
        static final String MAX_BATCHES = "Max Batches";
        static final String MAX_RECORDS = "Max Records";
        static final String LAST_UPDATE = "Last Update";
        static final String LAST_PROGRESS = "Last Progress";
        static final String PEAK_MEMORY = "Peak Memory";
        static final String STATE = "State";

        private FragmentTblTxt() {
        }
    }

    private class FragmentTblTooltip {
        static final String MINOR_FRAGMENT = "Minor Fragment ID";
        static final String HOSTNAME = "Host on which the fragment ran";
        static final String START_TIME = "Fragment Start Time";
        static final String END_TIME = "Fragment End Time";
        static final String RUNTIME = "Duration of the Fragment";
        static final String MAX_BATCHES = "Max Records processed by the fragment";
        static final String MAX_RECORDS = "Max Batches processed by the fragment";
        static final String LAST_UPDATE = "Last time fragment reported heartbeat";
        static final String LAST_PROGRESS = "Last time fragment reported back metrics";
        static final String PEAK_MEMORY = "Fragment Peak Memory Usage";
        static final String STATE = "State of the fragment";

        private FragmentTblTooltip() {
        }
    }
}

